/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiTreeHelper.java 1808 2010-11-25 14:27:29Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/tree/helpers/VradiTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.tree.helpers;

import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

/**
 * Navigation tree helpers.
 *
 * @author sletellier
 * @see jaxx.runtime.swing.nav.tree.NavTreeHelper
 */
public abstract class VradiTreeHelper<C extends BusinessEntity> extends NavTreeHelper<VradiTreeNode> implements VradiEntitiesListener<C> {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(VradiTreeHelper.class);

    protected List<String> idsLoaded = new ArrayList<String>();

    @Override
    public void setUI(JTree tree,
                      boolean addExpandTreeListener,
                      boolean addOneClickSelectionListener,
                      TreeSelectionListener listener,
                      TreeWillExpandListener willExpandListener) {

        super.setUI(tree,
                addExpandTreeListener,
                addOneClickSelectionListener,
                listener,
                willExpandListener);

        // Add tree expend listener to keep loaded nodes ids
        tree.addTreeExpansionListener(new TreeExpansionListener(){
            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode) event.getPath().getLastPathComponent();
                registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode) event.getPath().getLastPathComponent();
                Enumeration<VradiTreeNode> enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeNode child = enumeration.nextElement();
                    idsLoaded.remove(child.getId());
                }
            }
        });
    }
    
    @Override
    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)dataProvider;
    }

    /*
     * Hack for use generic
     */
    @Override
    public VradiTreeNode getSelectedNode() {
        return super.getSelectedNode();
    }

    @Override
    public VradiTreeNode findNode(VradiTreeNode node, String... ids) {
        return super.findNode(node, ids);
    }

    @Override
    public VradiTreeNode getRootNode() {
        return super.getRootNode();
    }

    public List<String> getLoadedIds() {
        return idsLoaded;
    }

    public boolean isLoadedId(String id) {
        return idsLoaded.contains(id);
    }

    public void registerLoadedIds(VradiTreeNode node) {
        idsLoaded.add(node.getId());
        Enumeration<VradiTreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeNode child = enumeration.nextElement();
            idsLoaded.add(child.getId());
        }
    }

    public void refresh(VradiTreeNode node) {
        if (node == null) {
            return;
        }
        getBridge().nodeChanged(node);
    }

    public abstract void createEntityNode(String wikittyId);

    @Override
    public void entitiesAdded(Set<C> added) {

        log.info("entityAdded : " + added.size());

        for (C entity : added) {

            String wikittyId = ((BusinessEntity)entity).getWikittyId();

            // Refresh
            VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);
            // cas modification
            if (existingNode != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Client modification occured");
                }
                // Reconstruction des fils
                refresh(existingNode);
            }

            // cas creation
            else {
                if (log.isDebugEnabled()) {
                    log.debug("Client creation occured");
                }
                createEntityNode(wikittyId);
            }
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {

        log.info("entityRemoved : " + removed.size());
        removeEntities(removed);
    }

    public void removeEntities(Collection<String> entities) {

        for (String wikittyId : entities) {

            // If wikitty id it's not loaded, the event dont concerne this tree
            if (isLoadedId(wikittyId)) {

                VradiTreeNode node = findNode(getRootNode(), wikittyId);

                idsLoaded.remove(wikittyId);
                if (node != null) {

                    if (log.isDebugEnabled()) {
                        log.debug("Removing node " + wikittyId + " from parent");
                    }

                    VradiTreeNode parent = node.getParent();
                    int index = parent.getIndex(node);
                    node.removeFromParent();
                    getBridge().nodesWereRemoved(parent, new int[] {index}, new VradiTreeNode[]{node});
                }
            }
        }
    }
}
