/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminNavTreeFilter.java 1822 2010-12-14 09:46:22Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/AdminNavTreeFilter.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import javax.swing.tree.TreeModel;

import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tree.TreeFilter;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * Implementation of admin navigation tree filter.
 * 
 * Pour l'instant, le filter regarde principalement si le getName de l'intité
 * en question "contient" le {@link #filterString}.
 * 
 * Mais on pourrait matcher sur autre chose, description ...
 * 
 * @author chatellier
 * @version $Revision: 1822 $
 * 
 * Last update : $Date: 2010-12-14 10:46:22 +0100 (mar., 14 déc. 2010) $
 * By : $Author: sletellier $
 */
public class AdminNavTreeFilter implements TreeFilter {

    static private final Log log = LogFactory.getLog(AdminNavTreeFilter.class);

    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    /*
     * @see org.nuiton.widget.tree.TreeFilter#include(javax.swing.tree.TreeModel, java.lang.Object)
     */
    @Override
    public boolean include(TreeModel model, Object node) {

        // empty filter, no filtering
        if (StringUtils.isEmpty(filterString)) {
            return true;
        }

        // filter real user object
        if (log.isDebugEnabled()) {
            log.debug("Todo filter string : " + filterString + " on " + node);
        }

        VradiTreeNode vradiNode = (VradiTreeNode)node;
        String id = vradiNode.getId();
        Class<?> nodeType = vradiNode.getInternalClass();
        
        // si c'est un noeaud intermediaire, on l'affiche tout le temps
        if (vradiNode.isStringNode()) {
            return true;
        }

        // un client (si son nom match ou ses users)
        else if (nodeType.equals(Client.class)) {
            Client client = VradiService.getWikittyProxy().restore(Client.class, id);
            if (client.getName().toLowerCase().contains(filterString)) {
                return true;
            }

            // Get user category node
            List<User> users = VradiService.getVradiDataService().findClientUsers(id);
            if (users != null) {
                for (User user : users) {
                    if (user.getName().toLowerCase().contains(filterString)) {
                        return true;
                    }
                }
            }
        }

        // un utilisateur (filtre s'il match ou son client/group match)
        else if (nodeType.equals(User.class)) {
            User user = VradiService.getWikittyProxy().restore(User.class, id);
            if (user.getName().toLowerCase().contains(filterString)) {
                return true;
            }

            VradiTreeNode clientNode = AdminNavigationTreeHelper.getParentNode(vradiNode, Client.class);
            
            // cas ou le parent est un client
            if (clientNode != null) {
                Client client = VradiService.getWikittyProxy().restore(Client.class, clientNode.getId());
                if (client.getName().toLowerCase().contains(filterString)) {
                    return true;
                }
            }
            // cas ou le parent est un group
            else {
                VradiTreeNode groupNode = AdminNavigationTreeHelper.getParentNode(vradiNode, Group.class);
                Group group = VradiService.getWikittyProxy().restore(Group.class, groupNode.getId());
                if (group.getName().toLowerCase().contains(filterString)) {
                    return true;
                }
            }
        }

        // group
        else if (nodeType.equals(Group.class)) {
            Group group = VradiService.getWikittyProxy().restore(Group.class, id);
            if (group.getName().toLowerCase().contains(filterString)) {
                return true;
            }
            Set<String> userIds = group.getUser();
            if (userIds != null) {
                List<User> users = VradiService.getWikittyProxy().restore(User.class, new ArrayList<String>(userIds));
                for (User user : users) {
                    if (user.getName().toLowerCase().contains(filterString)) {
                        return true;
                    }
                }
            }
        }

        // un formulaire (filtre sur son nom seulement)
        else if (nodeType.equals(WikittyExtension.class)) {
            WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
            WikittyExtension formType = wikittyProxy.restoreExtension(id);
            if (formType.getName().toLowerCase().contains(filterString)) {
                return true;
            }
        }
        
        // flux xml
        else if (nodeType.equals(XmlStream.class)) {
            XmlStream xmlStream = VradiService.getWikittyProxy().restore(XmlStream.class, id);
            
            if (xmlStream.getName().toLowerCase().contains(filterString)) {
                return true;
            }
        }

        return false;
    }

}
