/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Zz28buRWmFcu25Dhx5Nj54WzWdoxFUmzGmz0UC2S7XduVErvKD1gKYKwPLqWhJCaj4YTDsSdrpOif0D+hvfdSoLeeih567qGXov9CUeyh17aP5IxGMx5J43EDRJbI9x6/7+N7JGf4u3+iosvR+lvs+wb3bEH7xNjfPjx81XpL2uJnxG1z6gjGkf43VUCFIzRvDtpdgR4c1aX7VuC+tcv6DrOJPeT9tI7KrvhgEbdHiBDok7hH23W3GoPup77j8TDqAFRa1N/88K/Cr81f/baAkO8AujJQWZvkFTGZrqMCNQWqwEgneMvCdhdgcGp3Ae+CbNu1sOu+xH3yHv0SzdbRjIM5BBNoIztlFUP5+45AK4L0HQsLUqPEMneobcJwb/YE+kmb9Y23HqduH/N2j7jGCccmNTxqYLNPbcNhjue4RjPV33HUEDMClYgviO1SZgu0KDkYkpeheUVmcyEO+fta1D7fkXHdF8wklkDfTALVl3YJUE3csogKEIWd3VStXwh0OzY/7imgMlSftCxF+Db367hFLPCoSBZ+YKpbpdHNge3C5n6jzZllvca2HOJWzCHqinsFTNXYAq0y3jXeQl6/E8zRrr6xfzhAdjcSeHN/xxOC2TDSUmwk3RwfZWD9RDZsBJ0crcZkgAIwogKIMnTqCBW5B82g29H5mjmALl0ttxPVIgOq3v+sLP3tj//4Qy0skS0YeznVdKjCIXUdzhzCBZVDX9f14Qlqbb3AztMjVHKJBcuDKv97KcAaQTeAg/FuqDSU7sZz7PYgRHH273/688ov/noFFWqobDFs1rC030Ml0eOgArNM3/nptwrR1dM5+FyE/1dAzw5YCz1nxQ62XPg7wxz83htqWGgxbhL+GlNbEDNs90Gneyk6DcC2Sn/591Lj99+GWk0B9jsjzSO9it+hGWpb1CZqQQnWitQFZN5xiWeyaE1IWyUQrBNz+03GrB3Mgxr6kfo00iRZbEOtU9tjnlvHHxhkG5oWXOpRgTWpybx2r+o72Da1akHfvElPKIjUoN/Dr8KTL31PjvBjxVt++0rCKO83HIsKWT0TgExDNfQYp98DGGxtW7Rr99VS+eBsuEga8nOX2a7AtnCN3erLZvXgo5xX8HvsajBfQmmtRMGasKS9Zi4ValG7fqbXgMh3XvmeEtrtSe4tmTxpZGa0I3wrCiqgqnLxWR/Hp16tNS/EZiFkE3henEtJcamTjsjHZ2Mcn4O9Z88vRuhaSCh0vTijsmJ0IB3GUiqEEwnU9L6kfhmnxIJ9C1qXTdLBniV2LeaSV7CeYY1xyWTHNhM9oHrM7OO27D6PCVj3YQWpcShfZ0L2TwGU455Cv3i2Aduj9DRAYG/jY1rkadk1KegVWawgLuS8piedjA6VhOf6Nukzm7YFmqpFgy/HB1fG6QjmZH8NurOjuJNAYbBOh/A6dUUcz6sIz6cpeCK3dGRL0rLRY6evQjt5vhkPsjgAeVeDhO0EptqApbFDu1448cModyHRtNWeXEDRjLaFhBWw8jap01Tx7o+OB+nmRFQfpFGN2afTXQ4nYnfYNjvhleSsWKyNkymSJFsSHNuuPLIl+Y4MF/K8l8ZTG6UTXAwJ1uEg6uHuxIwDbrPElrsV7N1PztZxu00cUVdDPOwSoYV6+MiA70Hro8/XNjr8uHaw8ehjUplg6jREo8MTUszSJ1/Zj2VzXIi76d7xSU/N74Ftuh6VpB61g0mKzORThNjHz3YmKuK9i+fKm1SBpFUGgbx32QXy3mUU6M3PMwgUULwVQ9XxLAueyAiRPE6oS9URqHK2Tt03tknaDKqNmA+lRMMSvE5IUB6OE1dhdcR4cRnW0mSIjCfoUBsYZtfhTgyXzXgfpyhx42y8EC8TQixaBJ+Qx6Pl+GTksHFBPkvNi0TwdFluhrK8HIqefb28EUNIfJrYvQ4TlKe1SZzm8rkgcXp30+hJs3RKV0NKVTDJeSwAMeJEXow5FoDxuGMBdGdHURlCoQVx40C2IyC3EkC0fTqUeWmxrQNmR7M4jEa+oxiJJftZqaSQyGDZcdwYwtG2qDpqJ3bkPKJcH0DZVUHzCdPlzHPieJ7lw3NtgOeZjJkdzlIid5sfnNHH2osgWhggulga3xwC5PethuAE988tDXkQVQaIDsO4+fIIHsqElyiuxmXzqKGC5tNJ9IiLPZ7E1LysTs0wbr70JjCeFYdUzV33VRksO46VJI60VShn8UfFdkFQt4ZA0b7DuKj68jOOai+PRup0vzcUMzuq+yNQwUZ5Hlw1n2RlNYX/L2D6x0jVLgxM65Yd2KejgHFC4RTnx5EdXGLfPdAB851F9JjDUMjo1JKtY84iz+U1Qs7DXSqO+OFOm4w73EmL8Yc7ZTGaxtWQxmWouFQktkc3SUWbjKMiLTJQkWYTqDTAJDuVSgwFbql31IlTWYxLMbBJfTUxHCbOZjWNjbIbc1SQdLalTYZnq1KHtT03fvsQAz6n3iU2cSuJPf449t6j4vkgr67LCyp2Qng1fMQff5EREb4fEW4x84MmHEIYUVRh9yS6BYFmrOA+YfXMJqdrO8zXFwwPJbUW5p+vfSEfGEM0SxGawCAdwmzQm+Gl6qg3uNe+NrHAay19//nNuVGm5Gc5wwABReif+m/+KMU+MzGcOCpf63ugNSwEpy1PkEtA0++2obtQzh9EVeCYGLczxIhe/o8JdD+jTOrydpTWWYIscXaq7+AgE7ahcE6JeSlc0vnmmAjrl46wCRH+B/+DuZpqIQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String extension;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected java.lang.String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable jTable,
                                                           Object o,
                                                           boolean b,
                                                           boolean b1,
                                                           int i,
                                                           int i1) {
    
                String sValue = null;
                if(o != null) {
                    java.util.List<String> sValues = (java.util.List<String>) o;
                    if(!sValues.isEmpty()) {
                        sValue = sValues.get(0);
                        sValue = sValue.substring(sValue.lastIndexOf(".") + 1);
                    }
                }
                return super.getTableCellRendererComponent(jTable,
                        sValue, b, b1, i, i1);
            }
        };
        JListCellRenderer renderer = new JListCellRenderer(tbc);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().saveTemplateFieldBinding(this);
    }

    public void doWindowClosing__on__templateFieldBindingUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getExtension() {
        return extension;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public java.lang.String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(java.lang.String newValue) {
        java.lang.String oldValue = this.extension;
        this.extension = newValue;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    public void setTemplate(java.lang.String newValue) {
        java.lang.String oldValue = this.template;
        this.template = newValue;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        // late initializer
        templateFieldBindingUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("templateFieldBindingUI", this);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}