/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminRequestUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_SAVE = "canSave";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALID_BUTTON_VISIBLE = "validButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.AdminRequestUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminRequestUI adminRequestUI = this;
    protected java.lang.Boolean canSave;
    protected javax.swing.JButton closeButton;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected java.lang.String request;
    protected com.jurismarches.vradi.ui.offer.OfferTable resultTable;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;
    protected javax.swing.JButton validButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        registerDataBinding(djb);
        djb.applyDataBinding();
        
        validate();
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void saveAndClose() {
        setRequest(getSearchUI().getRequest());
        close();
    }
    
    protected void close() {
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminRequestUI() {
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__closeButton(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__validButton(java.awt.event.ActionEvent event) {
        saveAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getCanSave() {
        return canSave;
    }

    public javax.swing.JButton getCloseButton() {
        return closeButton;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public java.lang.String getRequest() {
        return request;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public javax.swing.JButton getValidButton() {
        return validButton;
    }

    public java.lang.Boolean isCanSave() {
        return canSave !=null && canSave;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.canSave;
        this.canSave = newValue;
        firePropertyChange(PROPERTY_CAN_SAVE, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setRequest(java.lang.String newValue) {
        java.lang.String oldValue = this.request;
        this.request = newValue;
        firePropertyChange(PROPERTY_REQUEST, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminRequestUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createCanSave() {
        $objectMap.put("canSave", canSave = true);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new javax.swing.JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("vradi.common.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createRequest() {
        $objectMap.put("request", request = null);
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createValidButton() {
        $objectMap.put("validButton", validButton = new javax.swing.JButton());
        
        validButton.setName("validButton");
        validButton.setText(_("vradi.adminRequest.valid"));
        validButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminRequestUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add(closeButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(validButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setShowGrid(true);
        closeButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        validButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        adminRequestUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminRequestUI", this);
        createRequest();
        createCanSave();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createCloseButton();
        createValidButton();
        // inline creation of adminRequestUI
        setName("adminRequestUI");
        adminRequestUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.adminRequest.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_BUTTON_VISIBLE, true ,"canSave") {
        
            @Override
            public void processDataBinding() {
                validButton.setVisible(isCanSave());
            }
        });
    }

}