/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormLink;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.widget.tooltip.FocusableTip;

public class FormLinkCellRenderer
extends DefaultListCellRenderer {
    protected FocusableTip focusableTip = null;
    protected MultipleSelectionPane ui;
    protected Map<String, String> cachedRendered = new HashMap<String, String>();
    protected Map<String, String> cachedToolTip = new HashMap<String, String>();

    public FormLinkCellRenderer(MultipleSelectionPane ui) {
        this.ui = ui;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String rendered = " ";
        String formToolTip = null;
        String formLinkId = (String)value;
        if (formLinkId != null) {
            FormLink formLink;
            rendered = this.cachedRendered.get(formLinkId);
            formToolTip = this.cachedToolTip.get(formLinkId);
            if (rendered == null && (formLink = (FormLink)VradiService.getWikittyProxy().restore(FormLink.class, formLinkId)) != null) {
                rendered = formLink.getName();
                this.cachedRendered.put(formLinkId, rendered);
                formToolTip = this.loadFormToolTip(formLink);
            }
        }
        JLabel renderedComponant = (JLabel)super.getListCellRendererComponent((JList<?>)list, rendered, index, isSelected, cellHasFocus);
        if (formToolTip != null) {
            renderedComponant.setToolTipText(formToolTip);
        }
        return renderedComponant;
    }

    public void addAdded(FormLink formLink) {
        this.cachedRendered.put(formLink.getWikittyId(), formLink.getName());
        this.loadFormToolTip(formLink);
    }

    protected String loadFormToolTip(FormLink formLink) {
        Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formLink.getToForm());
        String formToolTip = ToolTipHelper.getToolTip(form);
        this.cachedToolTip.put(formLink.getWikittyId(), formToolTip);
        return formToolTip;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = super.getToolTipText(e);
        if (this.focusableTip == null) {
            this.focusableTip = new FocusableTip((JComponent)this.ui, true);
            this.focusableTip.setSize(600, 400);
        }
        this.focusableTip.toolTipRequested(e, text);
        return null;
    }
}

