/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.SendingViewUI;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsHighlighter;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class SendingViewManager
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(SendingViewManager.class);
    protected Session session;
    protected Sending sending;
    protected SendingViewUI ui;
    protected EmailFormsHighlighter emailFormsHighlighter;
    protected OfferListTableModel listTableModel;
    private static SendingViewManager instance;

    protected SendingViewManager() {
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.REMOTE);
    }

    public static SendingViewManager getInstance() {
        if (instance == null) {
            instance = new SendingViewManager();
        }
        return instance;
    }

    public void openUI(SendingViewUI ui, Session session, Sending sending) {
        if (sending == null) {
            return;
        }
        this.ui = ui;
        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        this.sending = (Sending)wikittyProxy.restore(Sending.class, sending.getWikittyId());
        this.session = session;
        ui.setBean(sending);
        ui.setSession(session);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        OfferTable listTable = ui.getListTable();
        this.listTableModel = (OfferListTableModel)listTable.getModel();
        this.emailFormsHighlighter = new EmailFormsHighlighter(this.listTableModel);
        this.updateDatas();
        listTable.setModel(this.listTableModel);
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        listTable.setDefaultRenderer(XmlStream.class, renderer);
        listTable.setDefaultRenderer(Status.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        listTable.addHighlighter((Highlighter)this.emailFormsHighlighter);
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener();
        listTable.addMouseListener(offerListTableMouseListener);
        ui.init();
    }

    protected void updateDatas() {
        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        FormPagedResult formPage = new FormPagedResult();
        HashSet formsIdsToDisplay = new HashSet();
        Set forms = SendingHelper.extractForms((WikittyProxy)wikittyProxy, this.sending.getGroupForms());
        if (forms != null) {
            formsIdsToDisplay.addAll(forms);
        }
        Set deletedForms = SendingHelper.extractForms((WikittyProxy)wikittyProxy, this.sending.getDeletedGroupForms());
        Set addedForms = SendingHelper.extractForms((WikittyProxy)wikittyProxy, this.sending.getAddedGroupForms());
        if (deletedForms != null) {
            formsIdsToDisplay.addAll(deletedForms);
        }
        if (!formsIdsToDisplay.isEmpty()) {
            formPage.setFormsToShow(new ArrayList(formsIdsToDisplay));
        }
        this.emailFormsHighlighter.setFormsAdded(addedForms);
        this.emailFormsHighlighter.setFormsDeleted(deletedForms);
        this.listTableModel.setFormPagedResult(formPage);
        this.emailFormsHighlighter.notifyChange();
    }

    protected void refresh() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
                SendingViewManager.this.sending = (Sending)wikittyProxy.restore(Sending.class, SendingViewManager.this.sending.getWikittyId());
                SendingViewManager.this.ui.setBean(SendingViewManager.this.sending);
                SendingViewManager.this.updateDatas();
            }
        });
    }

    public void putWikitty(WikittyServiceEvent event) {
        if (this.sending == null) {
            return;
        }
        Map idAndExtensions = event.getIdExtensions();
        boolean refresh = false;
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions;
            if (idAndExtensions == null || !(wikittyExtensions = (Set)idAndExtensions.get(wikittyId)).contains("Sending") || !wikittyId.equals(this.sending.getWikittyId())) continue;
            refresh = true;
        }
        if (refresh) {
            this.refresh();
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
    }

    public void removeExtension(WikittyServiceEvent event) {
    }

    public void clearExtension(WikittyServiceEvent event) {
    }

    public MouseListener getOfferListTableMouseListener() {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                JXTable listTable = (JXTable)e.getSource();
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        SendingViewManager.this.ui.setCursor(Cursor.getPredefinedCursor(3));
                        EmailHandler handler = UIHelper.getHandler((JAXXContext)SendingViewManager.this.ui, EmailHandler.class);
                        handler.selectOffer((JAXXContext)SendingViewManager.this.ui, (JTable)listTable);
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't open offer", (Throwable)ex);
                        }
                        ErrorDialogUI.showError((Exception)ex);
                    }
                    finally {
                        SendingViewManager.this.ui.setCursor(null);
                    }
                } else if (e.getButton() == 3) {
                    int[] selectedRows = listTable.getSelectedRows();
                    int rowClicked = listTable.rowAtPoint(e.getPoint());
                    boolean rowClickedSelected = false;
                    if (selectedRows == null || selectedRows.length == 0) {
                        listTable.getSelectionModel().setSelectionInterval(rowClicked, rowClicked);
                        rowClickedSelected = true;
                    } else {
                        int i = 0;
                        while (i < selectedRows.length && !rowClickedSelected) {
                            rowClickedSelected = rowClicked == selectedRows[i++];
                        }
                    }
                    if (rowClickedSelected) {
                        SendingViewManager.this.showOfferListContextMenu(SendingViewManager.this.ui, listTable, SendingViewManager.this.ui.getOfferListTableModel(), e);
                    }
                }
            }
        };
    }

    protected void showOfferListContextMenu(final SendingViewUI ui, JXTable table, OfferListTableModel model, MouseEvent e) {
        boolean enabled = ui.getSession() != null && ui.isNotClosed();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem removeFormFromSession = new JMenuItem(I18n._("vradi.email.removeFormFromSession"));
        removeFormFromSession.setEnabled(enabled);
        if (enabled) {
            removeFormFromSession.addActionListener(new RemoveAllFormFromSession(ui, table, model));
        }
        menu.add(removeFormFromSession);
        JMenuItem removeFormFromSessionForUser = new JMenuItem(I18n._("vradi.email.removeFormFromSessionForUser"));
        removeFormFromSessionForUser.setEnabled(enabled);
        if (enabled) {
            removeFormFromSessionForUser.addActionListener(new RemoveFormFromSessionForUser(ui, table, model));
        }
        menu.add(removeFormFromSessionForUser);
        int[] selectedRows = table.getSelectedRows();
        final ArrayList<String> formsIdsToUpdate = new ArrayList<String>();
        for (int row : selectedRows) {
            Set deletedFormsIds;
            row = table.convertRowIndexToModel(row);
            FormPagedResult formPage = this.listTableModel.getFormPagedResult();
            List formsToShow = formPage.getFormsIdsToShow();
            String formId = (String)formsToShow.get(row);
            if (formId == null || (deletedFormsIds = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), this.sending.getDeletedGroupForms())) == null || !deletedFormsIds.contains(formId)) continue;
            formsIdsToUpdate.add(formId);
        }
        if (!formsIdsToUpdate.isEmpty()) {
            JMenuItem revertDeletion = new JMenuItem(I18n._("vradi.email.forms.revertDeletion"));
            revertDeletion.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmailHandler handler = UIHelper.getHandler((JAXXContext)ui, EmailHandler.class);
                    handler.revertDeletion(ui, SendingViewManager.this.sending, formsIdsToUpdate);
                }
            });
            revertDeletion.setEnabled(this.session != null);
            menu.add(revertDeletion);
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected class RemoveFormFromSessionForUser
    extends RemoveFormFromSession {
        public RemoveFormFromSessionForUser(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            super(ui, listTable, tableModel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.handler.askToRemoveUserForm(this.ui, EmailDataHelper.convertFormsIdsToString(this.formsIdsToUpdate), this.user.getName())) {
                this.handler.removeUserSending((JAXXContext)this.ui, this.session, this.formsIdsToUpdate, new Object[]{this.user}, false);
            }
        }
    }

    protected class RemoveAllFormFromSession
    extends RemoveFormFromSession {
        public RemoveAllFormFromSession(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            super(ui, listTable, tableModel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.handler.askToRemoveAllForm(this.ui, EmailDataHelper.convertFormsIdsToString(this.formsIdsToUpdate))) {
                VradiTask<Void> removeFormsFromSessionTask = new VradiTask<Void>((JAXXContext)this.ui){

                    @Override
                    public Void doAction() throws Exception {
                        VradiService.getVradiStorageService().removeFormsFromSession(RemoveAllFormFromSession.this.session.getWikittyId(), RemoveAllFormFromSession.this.formsIdsToUpdate);
                        return null;
                    }
                };
                removeFormsFromSessionTask.execute();
            }
        }
    }

    protected abstract class RemoveFormFromSession
    implements ActionListener {
        protected List<String> formsIdsToUpdate = new ArrayList<String>();
        protected SendingViewUI ui;
        protected User user;
        protected Session session;
        protected EmailHandler handler;

        protected RemoveFormFromSession(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            int[] selectedRows;
            this.ui = ui;
            this.handler = UIHelper.getHandler((JAXXContext)ui, EmailHandler.class);
            Sending sending = ui.getBean();
            this.user = (User)VradiService.getWikittyProxy().restore(User.class, sending.getUser());
            this.session = VradiService.getVradiDataService().getSessionBySending(sending.getWikittyId());
            for (int row : selectedRows = listTable.getSelectedRows()) {
                row = listTable.convertRowIndexToModel(row);
                FormPagedResult formPage = tableModel.getFormPagedResult();
                List formsIdsToShow = formPage.getFormsIdsToShow();
                String formId = (String)formsIdsToShow.get(row);
                if (formId == null) continue;
                this.formsIdsToUpdate.add(formId);
            }
        }
    }
}

