/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.loadors.GroupsNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.Set;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);

    public GroupNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.GROUP.getCategoryName(), null, new GroupsNodeLoadors());
    }

    @Override
    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + wikittyId));
        }
        if (wikittyExtensions.contains("Group")) {
            VradiTreeNode existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            if (existingNode != null) {
                this.refresh(existingNode);
                Group group = (Group)VradiService.getWikittyProxy().restore(Group.class, wikittyId);
                Set<String> userIds = group.getUser();
                if (userIds != null) {
                    for (String userId : userIds) {
                        VradiTreeNode userNode = (VradiTreeNode)this.findNode((NavNode)existingNode, new String[]{userId});
                        if (userNode != null) continue;
                        VradiTreeNode userCategory = (VradiTreeNode)this.findNode((NavNode)existingNode, new String[]{AdminBeanConstant.USER.getCategoryName()});
                        userNode = new VradiTreeNode(User.class, userId, null, null);
                        this.insertNode((NavNode)userCategory, (NavNode)userNode);
                    }
                }
            } else {
                this.createGroupNode(wikittyId, false);
            }
        }
    }
}

