/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import javax.activation.DataSource;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.webharvest.gui.ResourceManager;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.MailPlugin;
import org.webharvest.runtime.processors.plugins.MailPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class MailAttachPlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "mail-attach";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        BaseProcessor processor = scraper.getRunningProcessorOfType(MailPlugin.class);
        if (processor != null) {
            MailPlugin mailPlugin = (MailPlugin)processor;
            Email email = mailPlugin.getEmail();
            if (email instanceof HtmlEmail) {
                String attachmentName = this.evaluateAttribute("name", scraper);
                if (CommonUtil.isEmptyString(attachmentName)) {
                    attachmentName = mailPlugin.getNextAttachmentName();
                }
                String mimeType = this.evaluateAttribute("mimetype", scraper);
                boolean isInline = this.evaluateAttributeAsBoolean("inline", false, scraper);
                HtmlEmail htmlEmail = (HtmlEmail)email;
                Variable bodyVar = this.executeBody(scraper, context);
                try {
                    if (CommonUtil.isEmptyString(mimeType)) {
                        mimeType = isInline ? "image/jpeg" : "application/octet-stream";
                    }
                    DataSource dataSource = MailPlugin.createDataSourceOfVariable(bodyVar, scraper.getConfiguration().getCharset(), mimeType);
                    String cid = htmlEmail.embed(dataSource, attachmentName);
                    return isInline ? new NodeVariable("cid:" + cid) : new EmptyVariable();
                }
                catch (IOException e) {
                    throw new MailPluginException(e);
                }
                catch (EmailException e) {
                    throw new MailPluginException(e);
                }
            }
            throw new MailPluginException("Cannot use mail attach plugin if mail type is not html!");
        }
        throw new MailPluginException("Cannot use mail attach plugin out of mail plugin context!");
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"name", "mimetype", "inline"};
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("mimetype".equalsIgnoreCase(attributeName)) {
            return ResourceManager.MIME_TYPES;
        }
        if ("inline".equalsIgnoreCase(attributeName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }
}

