/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.XmlFileFilter;
import org.webharvest.gui.component.AlertDialog;

public class GuiUtils {
    private static Component parent;
    private static final JFileChooser fileChooser;

    public static synchronized void init(Component parent) {
        GuiUtils.parent = parent;
        fileChooser.setFileFilter(new XmlFileFilter());
        fileChooser.setMultiSelectionEnabled(true);
    }

    public static void showErrorMessage(String msg) {
        new AlertDialog(null, "Error", msg, ResourceManager.ERROR_ICON, new int[]{0}, new String[]{"OK"}).display();
    }

    public static void showWarningMessage(String msg) {
        new AlertDialog(null, "Warning", msg, ResourceManager.WARNING_ICON, new int[]{0}, new String[]{"OK"}).display();
    }

    public static void showInfoMessage(String msg) {
        new AlertDialog(null, "Information", msg, ResourceManager.INFO_ICON, new int[]{0}, new String[]{"OK"}).display();
    }

    public static int showQuestionBox(String msg, String title, boolean hasCancelButton, Icon icon) {
        String[] stringArray;
        int[] nArray;
        if (hasCancelButton) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        int[] options = nArray;
        if (hasCancelButton) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Yes";
            stringArray2[1] = "No";
            stringArray = stringArray2;
            stringArray2[2] = "Cancel";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        String[] buttLabels = stringArray;
        return new AlertDialog(null, title, msg, icon, options, buttLabels).display();
    }

    public static int showQuestionBox(String msg, boolean hasCancelButton) {
        return GuiUtils.showQuestionBox(msg, "Question", hasCancelButton, ResourceManager.QUESTION_ICON);
    }

    public static int showWarningQuestionBox(String msg, boolean hasCancelButton) {
        return GuiUtils.showQuestionBox(msg, "Warning", hasCancelButton, ResourceManager.QUESTION_ICON);
    }

    public static JFileChooser getFileChooser() {
        return fileChooser;
    }

    public static Frame getActiveFrame() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return window instanceof Frame ? (Frame)window : null;
    }

    public static void centerRelativeTo(Component comp, Component parent) {
        if (comp != null && parent != null) {
            Dimension dialogSize = comp.getSize();
            if (parent.isVisible()) {
                Point point = parent.getLocationOnScreen();
                Dimension parentSize = parent.getSize();
                int newX = point.x + (parentSize.width - dialogSize.width) / 2;
                int newY = point.y + (parentSize.height - dialogSize.height) / 2;
                if (newX >= 0 && newY >= 0) {
                    comp.setLocation(newX, newY);
                    return;
                }
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int newX = (screenSize.width - dialogSize.width) / 2;
            int newY = (screenSize.height - dialogSize.height) / 2;
            if (newX >= 0 && newY >= 0) {
                comp.setLocation(newX, newY);
            }
        }
    }

    public static Component getParentOfType(Component component, Class parentClass) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getClass() != parentClass) continue;
            return parent;
        }
        return null;
    }

    static {
        fileChooser = new JFileChooser();
    }
}

