/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkBeanValidator<B> {
    private static final Log log = LogFactory.getLog(XWorkBeanValidator.class);
    protected static final Map<String, List<String>> EMPTY_RESULT = Collections.unmodifiableMap(new HashMap());
    protected final Class<B> beanClass;
    protected String contextName;
    protected Set<String> fieldNames;
    protected boolean includeDefaultContext;
    protected ValidationAwareSupport validationSupport;
    protected DelegatingValidatorContext validationContext;
    protected ActionValidatorManager validator;
    protected ActionContext context;

    public XWorkBeanValidator(Class<B> beanClass, String contextName) {
        this(beanClass, contextName, true, BeanValidatorUtil.getSharedValueStack());
    }

    public XWorkBeanValidator(Class<B> beanClass, String contextName, ValueStack vs) {
        this(beanClass, contextName, true, vs);
    }

    public XWorkBeanValidator(Class<B> beanClass, String contextName, boolean includeDefaultContext) {
        this(beanClass, contextName, includeDefaultContext, BeanValidatorUtil.getSharedValueStack());
    }

    public XWorkBeanValidator(Class<B> beanClass, String contextName, boolean includeDefaultContext, ValueStack vs) {
        this.beanClass = beanClass;
        this.includeDefaultContext = includeDefaultContext;
        this.validationSupport = new ValidationAwareSupport();
        this.validationContext = new DelegatingValidatorContext((Object)this.validationSupport);
        if (vs == null) {
            ConfigurationManager confManager = new ConfigurationManager();
            Configuration conf = confManager.getConfiguration();
            Container container = conf.getContainer();
            ValueStackFactory stackFactory = (ValueStackFactory)container.getInstance(ValueStackFactory.class);
            vs = stackFactory.createValueStack();
            if (log.isDebugEnabled()) {
                log.info((Object)("create a standalone value stack " + vs));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("use given value stack " + vs));
        }
        this.context = new ActionContext(vs.getContext());
        ActionContext.setContext((ActionContext)this.context);
        Container container = this.context.getContainer();
        this.validator = (ActionValidatorManager)container.getInstance(ActionValidatorManager.class, "no-annotations");
        this.setContextName(contextName);
    }

    public boolean isIncludeDefaultContext() {
        return this.includeDefaultContext;
    }

    public Class<B> getBeanClass() {
        return this.beanClass;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public ActionValidatorManager getValidator() {
        return this.validator;
    }

    public boolean containsField(String fieldName) {
        return this.fieldNames.contains(fieldName);
    }

    public void setIncludeDefaultContext(boolean includeDefaultContext) {
        this.includeDefaultContext = includeDefaultContext;
        if (this.contextName != null) {
            this.setContextName(this.contextName);
        }
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
        this.initFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> validate(B bean) {
        if (bean == null) {
            throw new NullPointerException("bean can not be null in method validate");
        }
        Map<String, List<String>> result = EMPTY_RESULT;
        if (!this.fieldNames.isEmpty()) {
            try {
                if (ActionContext.getContext() == null) {
                    ActionContext.setContext((ActionContext)this.context);
                }
                this.validator.validate(bean, this.contextName, (ValidatorContext)this.validationContext);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Action errors: " + this.validationContext.getActionErrors()));
                    log.trace((Object)("Action messages: " + this.validationContext.getActionMessages()));
                    log.trace((Object)("Field errors: " + this.validationContext.getFieldErrors()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " : " + this.validationContext.getFieldErrors()));
                }
                if (this.validationContext.hasFieldErrors()) {
                    Map messages = this.validationContext.getFieldErrors();
                    result = new HashMap<String, List<String>>(messages.size());
                    for (Object fieldName : messages.keySet()) {
                        Collection c = (Collection)messages.get(fieldName);
                        ArrayList<String> mm = new ArrayList<String>(c.size());
                        for (Object message : c) {
                            String messageStr = message == null ? "" : message + "";
                            mm.add(messageStr.trim());
                        }
                        result.put(fieldName + "", mm);
                    }
                }
            }
            catch (ValidationException eee) {
                log.warn((Object)("Error during validation on " + this.beanClass + " for reason : " + eee.getMessage()), (Throwable)eee);
            }
            finally {
                this.validationSupport.clearErrorsAndMessages();
            }
        }
        return result;
    }

    public String toString() {
        return super.toString() + "<beanClass:" + this.beanClass + ", contextName:" + this.contextName + ">";
    }

    protected void initFields() {
        if (this.fieldNames != null) {
            this.fieldNames = null;
        }
        HashSet<String> detectedFieldNames = new HashSet<String>();
        int skip = 0;
        if (this.contextName != null && !this.includeDefaultContext) {
            for (Validator v : this.validator.getValidators(this.beanClass, null)) {
                if (!(v instanceof FieldValidator)) continue;
                ++skip;
            }
        }
        for (Validator v : this.validator.getValidators(this.beanClass, this.contextName)) {
            if (!(v instanceof FieldValidator)) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            FieldValidator fieldValidator = (FieldValidator)v;
            if (log.isDebugEnabled()) {
                log.debug((Object)("context " + this.contextName + " - field " + fieldValidator.getFieldName()));
            }
            String fName = fieldValidator.getFieldName();
            detectedFieldNames.add(fName);
        }
        this.fieldNames = Collections.unmodifiableSet(detectedFieldNames);
    }
}

