/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class WikittyImpl
implements Wikitty {
    private static final long serialVersionUID = 4910886672760691052L;
    protected String id;
    protected String version = "0.0";
    protected Date deleteDate = null;
    private transient PropertyChangeSupport propertyChange;
    protected HashMap<String, Object> fieldValue = new HashMap();
    protected Set<String> fieldDirty = new HashSet<String>();
    protected Map<String, WikittyExtension> extensions = new LinkedHashMap<String, WikittyExtension>();

    public WikittyImpl() {
        this(null);
    }

    public WikittyImpl(String id) {
        this.id = id == null ? WikittyUtil.genUID() : id;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isDeleted() {
        boolean result = this.deleteDate != null;
        return result;
    }

    @Override
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    @Override
    public void setDeleteDate(Date delete) {
        this.deleteDate = delete;
    }

    protected void setFieldDirty(String ext, String fieldName, Object oldValue, Object newValue) {
        String key = ext + "." + fieldName;
        this.fieldDirty.add(key);
        this.version = WikittyUtil.incrementMinorRevision(this.version);
        this.getPropertyChangeSupport().firePropertyChange(key, oldValue, newValue);
    }

    @Override
    public void addExtension(WikittyExtension ext) {
        String required = ext.getRequires();
        if (required != null && !required.isEmpty() && !this.extensions.containsKey(required)) {
            throw new WikittyException(String.format("You try to add extension '%s' that required not available extension '%s' in this wikitty", ext.getName(), required));
        }
        this.extensions.put(ext.name, ext);
    }

    @Override
    public boolean hasMetaExtension(String metaExtensionName, String extensionName) {
        String metaExtensionFQName = WikittyUtil.getFQMetaExtensionName(metaExtensionName, extensionName);
        boolean hasMetaExtension = this.extensions.containsKey(metaExtensionFQName);
        return hasMetaExtension;
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, WikittyExtension extension) {
        this.addMetaExtension(metaExtension, extension.getName());
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, String extensionName) {
        if (!this.hasExtension(extensionName)) {
            throw new IllegalArgumentException("this wikitty doesn't have an extension named " + extensionName);
        }
        String metaExtensionFQName = WikittyUtil.getFQMetaExtensionName(metaExtension.getName(), extensionName);
        this.extensions.put(metaExtensionFQName, metaExtension);
    }

    @Override
    public void addExtension(List<WikittyExtension> exts) {
        for (WikittyExtension ext : exts) {
            this.extensions.put(ext.name, ext);
        }
    }

    @Override
    public boolean hasExtension(String extName) {
        return this.extensions.containsKey(extName);
    }

    @Override
    public boolean hasField(String extName, String fieldName) {
        boolean result = false;
        WikittyExtension ext = this.extensions.get(extName);
        if (ext != null) {
            result = ext.getFieldType(fieldName) != null;
        }
        return result;
    }

    @Override
    public WikittyExtension getExtension(String ext) {
        WikittyExtension result = this.extensions.get(ext);
        return result;
    }

    @Override
    public Collection<String> getExtensionNames() {
        Set<String> result = this.extensions.keySet();
        return result;
    }

    @Override
    public Collection<WikittyExtension> getExtensions() {
        Collection<WikittyExtension> result = this.extensions.values();
        return result;
    }

    @Override
    public Collection<WikittyExtension> getExtensionDependencies(String ext, boolean recursively) {
        HashSet<WikittyExtension> result = new HashSet<WikittyExtension>();
        Collection<WikittyExtension> all = this.extensions.values();
        for (WikittyExtension dependency : all) {
            String requires = dependency.getRequires();
            if (requires == null || requires.isEmpty() || !requires.equals(ext)) continue;
            result.add(dependency);
            if (!recursively) continue;
            String dependencyName = dependency.getName();
            Collection<WikittyExtension> dependencies = this.getExtensionDependencies(dependencyName, recursively);
            result.addAll(dependencies);
        }
        return result;
    }

    @Override
    public FieldType getFieldType(String fqfieldName) {
        try {
            FieldType result;
            String[] field = fqfieldName.split("\\.");
            WikittyExtension ext = this.getExtension(field[0]);
            if (ext == null) {
                throw new WikittyException(String.format("Extension '%s' doesn't exists on wikitty '%s'", field[0], this.id));
            }
            String fieldName = field[1];
            int crochet = fieldName.indexOf("[");
            if (crochet != -1) {
                fieldName = fieldName.substring(0, crochet);
            }
            if ((result = ext.getFieldType(fieldName)) == null) {
                throw new WikittyException(String.format("field '%s' doesn't exists on extension '%s'", fieldName, field[0]));
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Field %s is not a fully qualified field name", fqfieldName), eee);
        }
    }

    @Override
    public void setField(String ext, String fieldName, Object value) {
        if (!this.hasField(ext, fieldName)) {
            String def = "";
            for (WikittyExtension extension : this.extensions.values()) {
                def = def + extension.toDefinition() + "\n";
            }
            throw new WikittyException(String.format("field '%s' is not valid, extensions definition : %s", ext + "." + fieldName, def));
        }
        String key = ext + "." + fieldName;
        Object oldValue = null;
        if (this.getPropertyChangeSupport().hasListeners(key)) {
            oldValue = this.fieldValue.get(key);
        }
        FieldType fieldType = this.getExtension(ext).getFieldType(fieldName);
        Object validValue = fieldType.getValidValue(value);
        this.fieldValue.put(key, validValue);
        this.setFieldDirty(ext, fieldName, oldValue, validValue);
    }

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        if (!this.hasField(ext, fieldName)) {
            throw new WikittyException(String.format("field '%s' is not a valid field", ext + "." + fieldName));
        }
        String key = ext + "." + fieldName;
        Object result = this.fieldValue.get(key);
        return result;
    }

    @Override
    public boolean getFieldAsBoolean(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            boolean result = WikittyUtil.toBoolean(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid boolean", ext + "." + fieldName), eee);
        }
    }

    @Override
    public BigDecimal getFieldAsBigDecimal(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            BigDecimal result = WikittyUtil.toBigDecimal(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid numeric", ext + "." + fieldName), eee);
        }
    }

    @Override
    public int getFieldAsInt(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            int result = value.intValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid int", ext + "." + fieldName), eee);
        }
    }

    @Override
    public long getFieldAsLong(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            long result = value.longValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid int", ext + "." + fieldName), eee);
        }
    }

    @Override
    public float getFieldAsFloat(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            float result = value.floatValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid float", ext + "." + fieldName), eee);
        }
    }

    @Override
    public double getFieldAsDouble(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            double result = value.doubleValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid float", ext + "." + fieldName), eee);
        }
    }

    @Override
    public String getFieldAsString(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            String result = WikittyUtil.toString(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid String", ext + "." + fieldName), eee);
        }
    }

    @Override
    public Date getFieldAsDate(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            Date result = WikittyUtil.toDate(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid Date", ext + "." + fieldName), eee);
        }
    }

    @Override
    public String getFieldAsWikitty(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        String result = WikittyUtil.toWikitty(value);
        return result;
    }

    @Override
    public <E> List<E> getFieldAsList(String ext, String fieldName, final Class<E> clazz) {
        try {
            final Collection collection = (Collection)this.getFieldAsObject(ext, fieldName);
            if (collection != null) {
                return new AbstractList<E>(){
                    List<E> contained;
                    {
                        this.contained = new ArrayList(collection);
                    }

                    @Override
                    public E get(int index) {
                        return WikittyUtil.cast(this.contained.get(index), clazz);
                    }

                    @Override
                    public int size() {
                        return this.contained.size();
                    }
                };
            }
            return null;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't add value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public <E> Set<E> getFieldAsSet(String ext, String fieldName, final Class<E> clazz) {
        try {
            final Set result = (Set)this.getFieldAsObject(ext, fieldName);
            if (result != null) {
                return new AbstractSet<E>(){
                    Set<E> contained;
                    {
                        this.contained = result;
                    }

                    @Override
                    public int size() {
                        return this.contained.size();
                    }

                    @Override
                    public Iterator<E> iterator() {
                        return new Iterator<E>(){
                            Iterator containedIterator;
                            {
                                this.containedIterator = contained.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.containedIterator.hasNext();
                            }

                            @Override
                            public E next() {
                                Object o = this.containedIterator.next();
                                return WikittyUtil.cast(o, clazz);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Not supported operation");
                            }
                        };
                    }
                };
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't add value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void addToField(String ext, String fieldName, Object value) {
        try {
            FieldType fieldType = this.getExtension(ext).getFieldType(fieldName);
            AbstractCollection col = (HashSet)this.getFieldAsObject(ext, fieldName);
            if (col == null) {
                col = fieldType.isUnique() ? new HashSet() : new ArrayList();
                col.add(value);
                this.setField(ext, fieldName, col);
            } else if (fieldType.isUnique()) {
                if (!col.contains(value)) {
                    if (col.size() + 1 > fieldType.getUpperBound()) {
                        throw new WikittyException(String.format("Can't add value for field '%s', upper bound is reached", ext + "." + fieldName));
                    }
                    col.add(value);
                    this.setFieldDirty(ext, fieldName, null, col);
                }
            } else {
                if (col.size() + 1 > fieldType.getUpperBound()) {
                    throw new WikittyException(String.format("Can't add value for field '%s', upper bound is reached", ext + "." + fieldName));
                }
                col.add(value);
                this.setFieldDirty(ext, fieldName, null, col);
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't add value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void removeFromField(String ext, String fieldName, Object value) {
        try {
            Collection col = (Collection)this.getFieldAsObject(ext, fieldName);
            if (col != null) {
                FieldType type = this.getExtension(ext).getFieldType(fieldName);
                if (col.contains(value)) {
                    if (col.size() - 1 < type.getLowerBound()) {
                        throw new WikittyException(String.format("Can't remove value for field '%s', lower bound is reached", ext + "." + fieldName));
                    }
                    if (col.remove(value)) {
                        this.setFieldDirty(ext, fieldName, null, col);
                    }
                }
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't remove value for field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void clearField(String ext, String fieldName) {
        FieldType type = this.getExtension(ext).getFieldType(fieldName);
        if (type.getLowerBound() > 0) {
            throw new WikittyException(String.format("Can't clear values for field '%s', lower bound is > 0", ext + "." + fieldName));
        }
        try {
            Collection col = (Collection)this.getFieldAsObject(ext, fieldName);
            if (col != null) {
                col.clear();
                this.setFieldDirty(ext, fieldName, null, col);
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't clear value for field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void addToField(String fqFieldName, Object value) {
        String[] extAndField = fqFieldName.split("\\.");
        this.addToField(extAndField[0], extAndField[1], value);
    }

    @Override
    public void removeFromField(String fqFieldName, Object value) {
        String[] extAndField = fqFieldName.split("\\.");
        this.removeFromField(extAndField[0], extAndField[1], value);
    }

    @Override
    public void clearField(String fqFieldName) {
        String[] extAndField = fqFieldName.split("\\.");
        this.clearField(extAndField[0], extAndField[1]);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Wikitty) {
            Wikitty other = (Wikitty)obj;
            result = this.id.equals(other.getId());
        }
        return result;
    }

    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }

    @Override
    public Set<String> fieldNames() {
        return this.fieldValue.keySet();
    }

    @Override
    public Object getFqField(String fqFieldName) {
        return this.fieldValue.get(fqFieldName);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Set<String> getDirty() {
        return this.fieldDirty;
    }

    @Override
    public void clearDirty() {
        this.fieldDirty.clear();
    }

    @Override
    public void setFqField(String fieldName, Object value) {
        FieldType fieldType = this.getFieldType(fieldName);
        Object validValue = fieldType.getValidValue(value);
        this.fieldValue.put(fieldName, validValue);
    }

    @Override
    public boolean isEmpty() {
        return this.fieldValue.isEmpty();
    }

    public String toString() {
        boolean cr = true;
        String str = "[" + this.getId() + ":" + this.getVersion() + "] {";
        for (String extName : this.getExtensionNames()) {
            WikittyExtension ext = this.getExtension(extName);
            str = str + (cr ? "\n" : "") + "\t<" + extName + ">\n";
            cr = false;
            for (String fieldName : ext.getFieldNames()) {
                str = str + "\t\t" + fieldName + " = " + this.getFieldAsString(extName, fieldName) + "\n";
            }
        }
        str = str + "}";
        return str;
    }

    @Override
    public WikittyImpl clone() throws CloneNotSupportedException {
        WikittyImpl clone = (WikittyImpl)super.clone();
        clone.fieldValue = new HashMap();
        for (Map.Entry<String, Object> aFieldValue : this.fieldValue.entrySet()) {
            clone.fieldValue.put(aFieldValue.getKey(), aFieldValue.getValue());
        }
        clone.clearDirty();
        return clone;
    }
}

