/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import org.apache.solr.schema.SchemaField;

public class CopyField {
    private final SchemaField source;
    private final SchemaField destination;
    private final int maxChars;
    public static final int UNLIMITED = 0;

    public CopyField(SchemaField source, SchemaField destination) {
        this(source, destination, 0);
    }

    public CopyField(SchemaField source, SchemaField destination, int maxChars) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("Source or Destination SchemaField can't be NULL.");
        }
        if (maxChars < 0) {
            throw new IllegalArgumentException("Attribute maxChars can't have a negative value.");
        }
        this.source = source;
        this.destination = destination;
        this.maxChars = maxChars;
    }

    public String getLimitedValue(String val) {
        return this.maxChars == 0 || val.length() < this.maxChars ? val : val.substring(0, this.maxChars);
    }

    public SchemaField getSource() {
        return this.source;
    }

    public SchemaField getDestination() {
        return this.destination;
    }

    public int getMaxChars() {
        return this.maxChars;
    }
}

