/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;

public class AnnotationNode
extends ASTNode {
    private ClassNode classNode;
    private Map members = new HashMap();

    public AnnotationNode(ClassNode classNode) {
        this.classNode = classNode;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public Map getMembers() {
        return this.members;
    }

    public Expression getMember(String name) {
        return (Expression)this.members.get(name);
    }

    public void addMember(String name, Expression value) {
        Expression oldValue = (Expression)this.members.get(name);
        if (oldValue == null) {
            this.members.put(name, value);
        } else {
            ArrayList<Expression> list = null;
            if (oldValue instanceof List) {
                list = (ArrayList<Expression>)((Object)oldValue);
            } else {
                list = new ArrayList<Expression>();
                list.add(oldValue);
                this.members.put(name, list);
            }
            list.add(value);
        }
    }

    public void setMember(String name, Expression value) {
        this.members.put(name, value);
    }

    public boolean isBuiltIn() {
        return this.classNode.getName().equals("Property");
    }
}

