/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jgroups.util.Buffer;

public class ExposedByteArrayOutputStream
extends ByteArrayOutputStream {
    public ExposedByteArrayOutputStream() {
    }

    public ExposedByteArrayOutputStream(int size) {
        super(size);
    }

    public void reset(int max_size) {
        this.reset();
        if (this.buf == null || this.buf.length > max_size) {
            this.buf = new byte[max_size];
        }
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public Buffer getBuffer() {
        return new Buffer(this.buf, 0, this.count);
    }

    public int getCapacity() {
        return this.buf.length;
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    @Deprecated
    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }
}

