/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class ChannelCallbackTest
extends ReceiverAdapter
implements ChannelListener {
    JChannel channel;

    public static void main(String[] args) {
        try {
            new ChannelCallbackTest().start();
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }

    private void start() throws ChannelException {
        this.channel = new JChannel();
        this.channel.setReceiver(this);
        this.channel.addChannelListener(this);
        this.channel.connect("bla");
        this.channel.send(null, null, (Serializable)((Object)"hello world"));
        Util.sleep(3000L);
        this.channel.close();
    }

    @Override
    public void receive(Message msg) {
        System.out.println("-- MSG: " + msg);
        try {
            Address dst = msg.getDest();
            if (dst == null || dst.isMulticastAddress()) {
                this.channel.send(msg.getSrc(), null, (Serializable)((Object)"this is a response"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- VIEW: " + new_view);
    }

    @Override
    public void channelConnected(Channel channel) {
        System.out.println("-- channel connected: " + channel);
    }

    @Override
    public void channelDisconnected(Channel channel) {
        System.out.println("-- channel disconnected: " + channel);
    }

    @Override
    public void channelClosed(Channel channel) {
        System.out.println("-- channel closed: " + channel);
    }

    @Override
    public void channelShunned() {
    }

    @Override
    public void channelReconnected(Address addr) {
    }
}

