/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin.loadors;

import java.util.Collections;
import java.util.List;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class ClientsNodeLoadors extends AbstractVradiNodeLoadors<Client> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6540304326033236054L;

    /** Logger */
    static private final Log log = LogFactory.getLog(ClientsNodeLoadors.class);

    public ClientsNodeLoadors() {
        super(Client.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Return all clients
        // FIXME EC20100628 : only get id here (wikitty entities not needed)
        VradiDataService dataService = getDataService(dataProvider);
        List<Client> clients = dataService.findAllClients();
        Collections.sort(clients, VradiComparators.CLIENT_COMPARATOR);
        return extractIds(clients);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}

