package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestListUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JPanel content;
    protected javax.swing.JScrollPane contentScroll;
    protected jaxx.runtime.swing.Table header;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RequestListUI $JPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        content.setVisible(false);
        content.removeAll();
        content.setAlignmentY(TOP_ALIGNMENT);
        
        if (bean != null && bean.getQueries() != null) {
            for (String query : bean.getQueries()) {
                createRequest(query);
            }
        }
        content.setVisible(true);    
    }
    
    protected void createRequest(final String query) {
        RequestSelectUI requestUI = new RequestSelectUI(RequestListUI.this);
        requestUI.setAlignmentY(TOP_ALIGNMENT);
    
        if (log.isDebugEnabled()){
            log.debug("Open query " + query);
        }
        
        try {
            requestUI.setBean(new QueryBean(query));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return;
        }
        
        requestUI.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RequestSelectUI query = (RequestSelectUI) evt.getSource();
    
                QueryBean oldValue = (QueryBean) evt.getOldValue();
                QueryBean newValue = (QueryBean) evt.getNewValue();
    
                if (log.isDebugEnabled()
                    && oldValue != null
                    && newValue != null) {
                    log.debug("Update query from '" + oldValue.getQueryLine() + "' to '" + newValue.getQueryLine() + "'");
                }
    
                bean.removeQueries(oldValue.getQueryLine());
    
                if (newValue == null) {
                    // this means remove
                    content.setVisible(false);
                    content.remove(query);
                    content.setVisible(true);
                } else {
                    // this means update
                    bean.addQueries(newValue.getQueryLine());
                }
            }
        });
        requestUI.setAlignmentY(Component.TOP_ALIGNMENT);
        content.add(requestUI);
        validate();
    }
    
    protected void showHistory() {
        AdminHandler handler = getContextValue(AdminHandler.class);
        handler.showHistory(bean.getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestListUI() {
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        showHistory();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        createRequest("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JScrollPane getContentScroll() {
        return contentScroll;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContentScroll() {
        if (!allComponentsCreated) {
            return;
        }
        contentScroll.getViewport().add(content);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createContentScroll() {
        $objectMap.put("contentScroll", contentScroll = new javax.swing.JScrollPane());
        
        contentScroll.setName("contentScroll");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        
        header.setName("header");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(header);
        add(contentScroll, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToContentScroll();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("history"));
        contentScroll.setColumnHeaderView(header);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createBean();
        createHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminRequest.title"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.history.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.new"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContentScroll();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0,1));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}