/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.util.Range;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MessageTest {
    public static void testFlags() {
        Message m1 = new Message();
        assert (!m1.isFlagSet((byte)1));
        try {
            m1.setFlag((byte)-22);
            assert (false) : "1002 is not a byte value";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        assert (m1.getFlags() == 0);
    }

    public static void testFlags2() {
        Message m1 = new Message();
        m1.setFlag((byte)1);
        assert (m1.isFlagSet((byte)1));
        assert (1 == (m1.getFlags() & 1));
        assert (!m1.isFlagSet((byte)4));
        Assert.assertNotSame((Object)(m1.getFlags() & 4), (Object)4);
    }

    public static void testFlags3() {
        Message msg = new Message();
        assert (!msg.isFlagSet((byte)1));
        msg.setFlag((byte)1);
        assert (msg.isFlagSet((byte)1));
        msg.setFlag((byte)1);
        assert (msg.isFlagSet((byte)1));
    }

    public static void testClearFlags() {
        Message msg = new Message();
        msg.setFlag((byte)1);
        assert (msg.isFlagSet((byte)1));
        msg.clearFlag((byte)1);
        assert (!msg.isFlagSet((byte)1));
        msg.clearFlag((byte)1);
        assert (!msg.isFlagSet((byte)1));
        msg.setFlag((byte)1);
        assert (msg.isFlagSet((byte)1));
    }

    public static void testClearFlags2() {
        Message msg = new Message();
        msg.setFlag((byte)1);
        msg.setFlag((byte)8);
        assert (!msg.isFlagSet((byte)4));
        assert (msg.isFlagSet((byte)1));
        assert (msg.isFlagSet((byte)8));
        msg.clearFlag((byte)1);
        assert (!msg.isFlagSet((byte)1));
        msg.setFlag((byte)4);
        assert (msg.isFlagSet((byte)4));
        assert (msg.isFlagSet((byte)8));
        msg.clearFlag((byte)8);
        assert (!msg.isFlagSet((byte)8));
        msg.clearFlag((byte)8);
        assert (!msg.isFlagSet((byte)8));
        msg.clearFlag((byte)4);
        msg.clearFlag((byte)1);
        assert (msg.getFlags() == 0);
        assert (!msg.isFlagSet((byte)1));
        assert (!msg.isFlagSet((byte)4));
        assert (!msg.isFlagSet((byte)8));
        msg.setFlag((byte)4);
        assert (msg.isFlagSet((byte)4));
        msg.setFlag((byte)4);
        assert (msg.isFlagSet((byte)4));
    }

    public static void testBufferSize() throws Exception {
        Message m1 = new Message(null, null, (Serializable)((Object)"bela"));
        assert (m1.getRawBuffer() != null);
        assert (m1.getBuffer() != null);
        Assert.assertEquals((int)m1.getBuffer().length, (int)m1.getLength());
        byte[] new_buf = new byte[]{109, 105, 99, 104, 101, 108, 108, 101};
        m1.setBuffer(new_buf);
        assert (m1.getRawBuffer() != null);
        assert (m1.getBuffer() != null);
        Assert.assertEquals((int)new_buf.length, (int)m1.getLength());
        Assert.assertEquals((int)m1.getBuffer().length, (int)m1.getLength());
    }

    public static void testBufferOffset() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, 0, 4);
        Message m2 = new Message(null, null, buf, 4, 3);
        byte[] b1 = new byte[m1.getLength()];
        System.arraycopy(m1.getRawBuffer(), m1.getOffset(), b1, 0, m1.getLength());
        byte[] b2 = new byte[m2.getLength()];
        System.arraycopy(m2.getRawBuffer(), m2.getOffset(), b2, 0, m2.getLength());
        Assert.assertEquals((int)4, (int)b1.length);
        Assert.assertEquals((int)3, (int)b2.length);
    }

    public static void testSetBufferWithNullBuffer() {
        byte[] buf = new byte[]{98, 101, 108, 97};
        Message m1 = new Message();
        m1.setBuffer(buf, 1, 2);
        Assert.assertEquals((int)1, (int)m1.getOffset());
        Assert.assertEquals((int)2, (int)m1.getLength());
        m1.setBuffer(null, 1, 2);
        Assert.assertEquals((int)0, (int)m1.getOffset());
        Assert.assertEquals((int)0, (int)m1.getLength());
    }

    @Test(groups={"functional"}, expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public static void testInvalidOffset() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, -1, 4);
        System.out.println("message is " + m1);
    }

    @Test(groups={"functional"}, expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public static void testInvalidLength() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, 3, 6);
        System.out.println("we should not get here with " + m1);
    }

    public static void testGetRawBuffer() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, 0, 4);
        Message m2 = new Message(null, null, buf, 4, 3);
        Assert.assertEquals((int)buf.length, (int)m1.getRawBuffer().length);
        Assert.assertEquals((int)4, (int)m1.getBuffer().length);
        Assert.assertEquals((int)4, (int)m1.getLength());
        Assert.assertEquals((int)buf.length, (int)m2.getRawBuffer().length);
        Assert.assertEquals((int)3, (int)m2.getBuffer().length);
        Assert.assertEquals((int)3, (int)m2.getLength());
    }

    public static void testSetObject() {
        String s1 = "Bela Ban";
        Message m1 = new Message(null, null, (Serializable)((Object)s1));
        Assert.assertEquals((int)0, (int)m1.getOffset());
        Assert.assertEquals((int)m1.getBuffer().length, (int)m1.getLength());
        String s2 = (String)m1.getObject();
        Assert.assertEquals((String)s2, (String)s1);
    }

    public static void testCopy() {
        Message m1 = new Message(null, null, (Serializable)((Object)"Bela Ban"));
        Message m2 = m1.copy();
        Assert.assertEquals((int)m1.getOffset(), (int)m2.getOffset());
        Assert.assertEquals((int)m1.getLength(), (int)m2.getLength());
    }

    public static void testCopyWithOffset() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message m1 = new Message(null, null, buf, 0, 4);
        Message m2 = new Message(null, null, buf, 4, 3);
        Message m3 = m1.copy();
        Message m4 = m2.copy();
        Assert.assertEquals((int)0, (int)m3.getOffset());
        Assert.assertEquals((int)4, (int)m3.getLength());
        Assert.assertEquals((int)4, (int)m3.getBuffer().length);
        Assert.assertEquals((int)4, (int)m4.getOffset());
        Assert.assertEquals((int)3, (int)m4.getLength());
        Assert.assertEquals((int)3, (int)m4.getBuffer().length);
    }

    public static void testComputeFragOffsets() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List<Range> retval = Util.computeFragOffsets(buf, 4);
        System.out.println("list is " + retval);
        Assert.assertEquals((int)3, (int)retval.size());
        Range r = retval.get(0);
        Assert.assertEquals((long)0L, (long)r.low);
        Assert.assertEquals((long)4L, (long)r.high);
        r = retval.get(1);
        Assert.assertEquals((long)4L, (long)r.low);
        Assert.assertEquals((long)4L, (long)r.high);
        r = retval.get(2);
        Assert.assertEquals((long)8L, (long)r.low);
        Assert.assertEquals((long)2L, (long)r.high);
    }

    public static void testComputeFragOffsetsWithOffsets() {
        List<Range> retval = Util.computeFragOffsets(3, 10, 4);
        System.out.println("list is " + retval);
        Assert.assertEquals((int)3, (int)retval.size());
        Range r = retval.get(0);
        Assert.assertEquals((long)3L, (long)r.low);
        Assert.assertEquals((long)4L, (long)r.high);
        r = retval.get(1);
        Assert.assertEquals((long)7L, (long)r.low);
        Assert.assertEquals((long)4L, (long)r.high);
        r = retval.get(2);
        Assert.assertEquals((long)11L, (long)r.low);
        Assert.assertEquals((long)2L, (long)r.high);
    }

    public static void testComputeFragOffsets2() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List<Range> retval = Util.computeFragOffsets(buf, 10);
        System.out.println("list is " + retval);
        Assert.assertEquals((int)1, (int)retval.size());
        Range r = retval.get(0);
        Assert.assertEquals((long)0L, (long)r.low);
        Assert.assertEquals((long)10L, (long)r.high);
    }

    public static void testComputeFragOffsets3() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List<Range> retval = Util.computeFragOffsets(buf, 100);
        System.out.println("list is " + retval);
        Assert.assertEquals((int)1, (int)retval.size());
        Range r = retval.get(0);
        Assert.assertEquals((long)0L, (long)r.low);
        Assert.assertEquals((long)10L, (long)r.high);
    }

    public static void testComputeFragOffsets4() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List<Range> retval = Util.computeFragOffsets(buf, 5);
        System.out.println("list is " + retval);
        Assert.assertEquals((int)2, (int)retval.size());
        Range r = retval.get(0);
        Assert.assertEquals((long)0L, (long)r.low);
        Assert.assertEquals((long)5L, (long)r.high);
        r = retval.get(1);
        Assert.assertEquals((long)5L, (long)r.low);
        Assert.assertEquals((long)5L, (long)r.high);
    }

    public static void testSizeNullMessage() throws Exception {
        Message msg = new Message();
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithDest() throws Exception {
        Message msg = new Message((Address)UUID.randomUUID(), null, null);
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithSrc() throws Exception {
        Message msg = new Message(null, (Address)UUID.randomUUID(), null);
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithDestAndSrc() throws Exception {
        Message msg = new Message((Address)UUID.randomUUID(), (Address)UUID.randomUUID(), null);
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithDestAndSrcAndFlags() throws Exception {
        Message msg = new Message((Address)UUID.randomUUID(), (Address)UUID.randomUUID(), null);
        msg.setFlag((byte)1);
        msg.setFlag((byte)4);
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithBuffer() throws Exception {
        Message msg = new Message(null, null, "bela".getBytes());
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithBuffer2() throws Exception {
        Message msg = new Message(null, null, new byte[]{98, 101, 108, 97});
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithBuffer3() throws Exception {
        Message msg = new Message(null, null, (Serializable)((Object)"bela"));
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithAdditionalData() throws Exception {
        UUID dest = UUID.randomUUID();
        dest.setAdditionalData("bela".getBytes());
        Message msg = new Message((Address)dest, null, null);
        MessageTest._testSize(msg);
    }

    public static void testSizeMessageWithDestAndSrcAndHeaders() throws Exception {
        Message msg = new Message((Address)UUID.randomUUID(), (Address)UUID.randomUUID(), "bela".getBytes());
        MessageTest.addHeaders(msg);
        MessageTest._testSize(msg);
    }

    private static void addHeaders(Message msg) {
        TpHeader tp_hdr = new TpHeader("DemoChannel2");
        msg.putHeader("TP", tp_hdr);
        PingHeader ping_hdr = new PingHeader(1, "demo-cluster");
        msg.putHeader("PING", ping_hdr);
        NakAckHeader nak_hdr = new NakAckHeader(2, 100L, 104L);
        msg.putHeader("NAKACK", nak_hdr);
    }

    private static void _testSize(Message msg) throws Exception {
        long size = msg.size();
        byte[] serialized_form = Util.streamableToByteBuffer(msg);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)size, (long)serialized_form.length);
    }
}

