/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Message;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.pbcast.NakAckHeader;

public class MessageStressTest {
    public static final int NUM = 1000000;
    public static final String UDP = "UDP";
    public static final String NAKACK = "NAKACK";
    public static final String UNICAST = "UNICAST";
    int cnt = 100000;

    private static void start() {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            Message msg = new Message();
            msg.putHeader(NAKACK, new NakAckHeader(1, i));
            msg.putHeader(UNICAST, new UNICAST.UnicastHeader(0, i));
            msg.putHeader(UDP, new TpHeader("demo"));
            msg.getHeader(UDP);
            msg.getHeader(NAKACK);
            msg.getHeader(UNICAST);
            msg.size();
        }
        long total = System.nanoTime() - start;
        double ns_per_msg = total / 1000000L;
        double us_per_msg = ns_per_msg / 1000.0;
        double ms_per_msg = us_per_msg / 1000.0;
        double msgs_per_ns = 1000000.0 / (double)total;
        double msgs_per_us = msgs_per_ns * 1000.0;
        double msgs_per_ms = msgs_per_us * 1000.0;
        double msgs_per_sec = msgs_per_ms * 1000.0;
        System.out.println("1000000 msgs, total time: " + total + " ns; " + ns_per_msg + " ns/msg, " + us_per_msg + " microsecs/msg, " + ms_per_msg + " ms/msg");
        System.out.println(msgs_per_ns + " messages/ns, " + msgs_per_us + " msgs/us, " + msgs_per_ms + " msgs/ms, " + msgs_per_sec + " msgs/sec");
    }

    public static void main(String[] args) {
        MessageStressTest.start();
    }
}

