/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "gossip-router"}, sequential=true)
public class GossipRouterTest {
    static final String PROPS = "tunnel.xml";
    GossipRouter router;
    JChannel c1;
    JChannel c2;
    String bind_addr = null;

    @BeforeClass
    protected void setUp() {
        this.bind_addr = Util.getProperty("jgroups.bind_addr");
        if (this.bind_addr == null) {
            StackType type = Util.getIpStackType();
            this.bind_addr = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() throws Exception {
        if (this.router != null) {
            this.router.stop();
            this.router = null;
        }
        Util.close(this.c2, this.c1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateStart() throws Exception {
        ReentrantLock lock = new ReentrantLock();
        Condition cond = lock.newCondition();
        AtomicBoolean done = new AtomicBoolean(false);
        System.out.println("-- starting first channel");
        this.c1 = new JChannel(PROPS);
        GossipRouterTest.changeMergeInterval(this.c1);
        this.c1.setReceiver(new MyReceiver("c1", done, lock, cond));
        this.c1.connect("demo");
        System.out.println("-- starting second channel");
        this.c2 = new JChannel(PROPS);
        GossipRouterTest.changeMergeInterval(this.c2);
        this.c2.setReceiver(new MyReceiver("c2", done, lock, cond));
        this.c2.connect("demo");
        System.out.println("-- starting GossipRouter");
        this.router = new GossipRouter(12001, this.bind_addr);
        this.router.start();
        System.out.println("-- waiting for merge to happen --");
        long target_time = System.currentTimeMillis() + 40000L;
        lock.lock();
        try {
            while (System.currentTimeMillis() < target_time && !done.get()) {
                cond.await(1000L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            lock.unlock();
        }
        Util.sleep(500L);
        View view = this.c1.getView();
        System.out.println("view=" + view);
        assert (view.size() == 2) : "view=" + view;
        Util.close(this.c2, this.c1);
    }

    private static void changeMergeInterval(JChannel c1) {
        MERGE2 merge = (MERGE2)c1.getProtocolStack().findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(1000L);
            merge.setMaxInterval(3000L);
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final String name;
        private final Lock lock;
        private final AtomicBoolean done;
        private final Condition cond;

        public MyReceiver(String name, AtomicBoolean done, Lock lock, Condition cond) {
            this.name = name;
            this.done = done;
            this.lock = lock;
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            if (new_view.size() == 2) {
                System.out.println("[" + this.name + "]: view=" + new_view);
                this.lock.lock();
                try {
                    this.done.set(true);
                    this.cond.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

