/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import org.webharvest.definition.HttpHeaderDef;
import org.webharvest.exception.HttpException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.HttpProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.Variable;

public class HttpHeaderProcessor
extends BaseProcessor {
    private HttpHeaderDef httpHeaderDef;

    public HttpHeaderProcessor(HttpHeaderDef httpHeaderDef) {
        super(httpHeaderDef);
        this.httpHeaderDef = httpHeaderDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String name = BaseTemplater.execute(this.httpHeaderDef.getName(), scriptEngine);
        Variable value = this.getBodyTextContent(this.httpHeaderDef, scraper, context);
        HttpProcessor httpProcessor = scraper.getRunningHttpProcessor();
        if (httpProcessor == null) {
            throw new HttpException("Usage of http-header processor is not allowed outside of http processor!");
        }
        httpProcessor.addHttpHeader(name, value.toString());
        this.setProperty("Name", name);
        return value;
    }
}

