/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckResponse {
    private boolean correctlySpelled;
    private String collation;
    private List<Suggestion> suggestions = new ArrayList<Suggestion>();
    Map<String, Suggestion> suggestionMap = new LinkedHashMap<String, Suggestion>();

    public SpellCheckResponse(NamedList<Object> spellInfo) {
        NamedList sugg = (NamedList)spellInfo.get("suggestions");
        if (sugg == null) {
            this.correctlySpelled = true;
            return;
        }
        for (int i = 0; i < sugg.size(); ++i) {
            String n = sugg.getName(i);
            if ("correctlySpelled".equals(n)) {
                this.correctlySpelled = (Boolean)sugg.getVal(i);
                continue;
            }
            if ("collation".equals(n)) {
                this.collation = (String)sugg.getVal(i);
                continue;
            }
            Suggestion s = new Suggestion(n, (NamedList)sugg.getVal(i));
            this.suggestionMap.put(n, s);
            this.suggestions.add(s);
        }
    }

    public boolean isCorrectlySpelled() {
        return this.correctlySpelled;
    }

    public List<Suggestion> getSuggestions() {
        return this.suggestions;
    }

    public Map<String, Suggestion> getSuggestionMap() {
        return this.suggestionMap;
    }

    public Suggestion getSuggestion(String token) {
        return this.suggestionMap.get(token);
    }

    public String getFirstSuggestion(String token) {
        Suggestion s = this.suggestionMap.get(token);
        if (s == null || s.getAlternatives().isEmpty()) {
            return null;
        }
        return s.getAlternatives().get(0);
    }

    public String getCollatedResult() {
        return this.collation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Suggestion {
        private String token;
        private int numFound;
        private int startOffset;
        private int endOffset;
        private int originalFrequency;
        private List<String> alternatives = new ArrayList<String>();
        private List<Integer> alternativeFrequencies;

        public Suggestion(String token, NamedList<Object> suggestion) {
            this.token = token;
            for (int i = 0; i < suggestion.size(); ++i) {
                String n = suggestion.getName(i);
                if ("numFound".equals(n)) {
                    this.numFound = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("startOffset".equals(n)) {
                    this.startOffset = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("endOffset".equals(n)) {
                    this.endOffset = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("origFreq".equals(n)) {
                    this.originalFrequency = (Integer)suggestion.getVal(i);
                    continue;
                }
                if (!"suggestion".equals(n)) continue;
                List list = (List)suggestion.getVal(i);
                if (list.size() > 0 && list.get(0) instanceof NamedList) {
                    this.alternativeFrequencies = new ArrayList<Integer>();
                    for (NamedList nl : list) {
                        this.alternatives.add((String)nl.get("word"));
                        this.alternativeFrequencies.add((Integer)nl.get("freq"));
                    }
                    continue;
                }
                this.alternatives.addAll(list);
            }
        }

        public String getToken() {
            return this.token;
        }

        public int getNumFound() {
            return this.numFound;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getOriginalFrequency() {
            return this.originalFrequency;
        }

        public List<String> getAlternatives() {
            return this.alternatives;
        }

        public List<Integer> getAlternativeFrequencies() {
            return this.alternativeFrequencies;
        }

        @Deprecated
        public List<String> getSuggestions() {
            return this.alternatives;
        }

        @Deprecated
        public List<Integer> getSuggestionFrequencies() {
            return this.alternativeFrequencies;
        }
    }
}

