/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav.treetable;

import java.util.Enumeration;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;

public class NavTreeTableNode<N extends NavTreeTableNode<N>>
extends DefaultMutableTreeTableNode
implements NavNode<NavTreeTableModel, N> {
    private static final Log log = LogFactory.getLog(NavNode.class);
    private static final long serialVersionUID = 1L;
    protected final Class<?> internalClass;
    protected final String context;
    protected final String id;
    protected boolean dirty = true;
    protected boolean loaded;
    protected final NavTreeTableNodeChildLoador<?, ?, N> childLoador;

    protected NavTreeTableNode(String id) {
        this(String.class, id, null, null);
    }

    public NavTreeTableNode(Class<?> internalClass, String id, String context, NavTreeTableNodeChildLoador<?, ?, N> childLoador) {
        this.internalClass = internalClass;
        this.id = id;
        this.context = context;
        this.childLoador = childLoador;
        if (this.isStaticNode()) {
            this.loaded = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new node : " + this));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public Class<?> getInternalClass() {
        return this.internalClass;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isStringNode() {
        return String.class.equals(this.internalClass);
    }

    @Override
    public boolean isStaticNode() {
        return this.childLoador == null;
    }

    @Override
    public N getContainerNode() {
        if (this.isRoot()) {
            return null;
        }
        if (this.isStringNode()) {
            return (N)((NavTreeTableNode)this.getParent()).getContainerNode();
        }
        return (N)this;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public N findNodeById(String id, NavBridge<NavTreeTableModel, N> model, NavDataProvider provider) {
        if (id == null) {
            return null;
        }
        if (id.equals(this.getId())) {
            return (N)this;
        }
        if (!this.isLoaded()) {
            this.populateChilds(model, provider);
        }
        if (this.isLeaf()) {
            return null;
        }
        Enumeration<N> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            NavTreeTableNode node = (NavTreeTableNode)enumeration.nextElement();
            NavNode nodeById = node.findNodeById(id, (NavBridge)model, provider);
            if (nodeById == null) continue;
            return (N)nodeById;
        }
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isLeaf() {
        return this.isStaticNode() ? super.isLeaf() : this.isLoaded() && this.getChildCount() == 0;
    }

    @Override
    public Object getUserObject() {
        return this.id;
    }

    @Override
    public String toString() {
        return System.identityHashCode(this) + "-" + this.id;
    }

    @Override
    public void populateNode(NavBridge<NavTreeTableModel, N> model, NavDataProvider provider, boolean populateChilds) {
        this.setDirty(true);
        if (populateChilds) {
            this.populateChilds(model, provider);
        }
    }

    @Override
    public void populateChilds(NavBridge<NavTreeTableModel, N> model, NavDataProvider provider) {
        if (this.isStaticNode()) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will load childs for " + this));
            }
            this.childLoador.loadChilds((NavTreeTableBridge)model, this, provider);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.loaded = true;
        }
    }

    @Override
    public N getParent() {
        return (N)((NavTreeTableNode)super.getParent());
    }

    public N getChildAt(int index) {
        return (N)((NavTreeTableNode)super.getChildAt(index));
    }

    public Enumeration<N> children() {
        return super.children();
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    @Override
    public void add(N node) {
        super.add(node);
    }

    public N[] getPathToRoot(NavTreeTableNode aNode, int depth) {
        NavTreeTableNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new NavTreeTableNode[depth];
        } else {
            retNodes = this.getPathToRoot((NavTreeTableNode)aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public void remove(N node) {
        super.remove(node);
    }

    @Override
    public void insert(N node, int position) {
        super.insert(node, position);
    }
}

