/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.offer.RequestFormViewUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyException;

public class RequestFormViewHandler {
    private static Log log = LogFactory.getLog(RequestFormViewHandler.class);
    private VradiStorageService vradiStorageService;

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public RequestFormViewUI initUI(JAXXContext rootContext, Map<QueryMaker, List<QueryBean>> queries) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        context.add("queries", queries);
        RequestFormViewUI requestFormViewUI = new RequestFormViewUI((JAXXContext)context);
        JXTreeTable resultTreeTable = requestFormViewUI.getResultTreeTable();
        JXTable resultTable = requestFormViewUI.getResultTable();
        resultTreeTable.expandAll();
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        resultTable.addHighlighter(highlighter);
        resultTreeTable.addHighlighter(highlighter);
        return requestFormViewUI;
    }

    public TableModel getResultTableModel(RequestFormViewUI context) {
        QueryTableModel tableModel = context.getContextValue(QueryTableModel.class);
        if (tableModel == null) {
            Map queries = context.getContextValue(Map.class, "queries");
            tableModel = new QueryTableModel(queries);
            context.setContextValue(tableModel);
            final JXTable resultTable = context.getResultTable();
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    resultTable.packAll();
                }
            });
        }
        return tableModel;
    }

    public TreeTableModel getResultTreeTableModel(RequestFormViewUI context) {
        QueryTreeTableModel treeTableModel = context.getContextValue(QueryTreeTableModel.class);
        if (treeTableModel == null) {
            Map queries = context.getContextValue(Map.class, "queries");
            treeTableModel = new QueryTreeTableModel(queries);
            context.setContextValue(treeTableModel);
            JXTreeTable resultTreeTable = context.getResultTreeTable();
            QueryTreeTableModelListener treeModelListener = new QueryTreeTableModelListener(resultTreeTable);
            treeTableModel.addTreeModelListener(treeModelListener);
        }
        return treeTableModel;
    }

    void close(RequestFormViewUI context) {
        context.setVisible(false);
        context.dispose();
    }

    class QueryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        final QueryBean[] queries;

        public QueryTableModel(Map<QueryMaker, List<QueryBean>> queryMap) {
            HashSet<QueryBean> querySet = new HashSet<QueryBean>();
            Collection<List<QueryBean>> lists = queryMap.values();
            for (List<QueryBean> list : lists) {
                querySet.addAll(list);
            }
            this.queries = new QueryBean[querySet.size()];
            querySet.toArray(this.queries);
        }

        @Override
        public String getColumnName(int column) {
            String columnName = null;
            if (column == 0) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.name");
            } else if (column == 1) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.description");
            } else if (column == 2) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.query");
            }
            return columnName;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            QueryBean queryBean = this.queries[rowIndex];
            String[] queryArray = queryBean.toArray();
            if (columnIndex < 2) {
                return queryArray[columnIndex + 1];
            }
            return queryArray[0];
        }

        @Override
        public int getRowCount() {
            return this.queries.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }
    }

    class QueryTreeTableModel
    extends AbstractTreeTableModel {
        final ArrayList<QueryMaker> topLevels;
        final HashMap<String, List<User>> userMap;
        final HashMap<String, List<QueryBean>> queryBeanMap;

        public QueryTreeTableModel(Map<QueryMaker, List<QueryBean>> queryMap) {
            super((Object)1L);
            this.topLevels = new ArrayList();
            this.userMap = new HashMap();
            this.queryBeanMap = new HashMap();
            HashMap<String, Client> clientMap = new HashMap<String, Client>();
            HashMap<String, Group> groupMap = new HashMap<String, Group>();
            for (Map.Entry<QueryMaker, List<QueryBean>> entry : queryMap.entrySet()) {
                QueryMaker queryMaker = entry.getKey();
                List<QueryBean> queries = entry.getValue();
                String wikittyId = queryMaker.getWikittyId();
                if (queryMaker instanceof Client) {
                    clientMap.put(wikittyId, (Client)queryMaker);
                } else if (queryMaker instanceof Group) {
                    groupMap.put(wikittyId, (Group)queryMaker);
                } else if (queryMaker instanceof User) {
                    User user = (User)queryMaker;
                    String clientId = user.getClient();
                    if (this.userMap.containsKey(clientId)) {
                        this.userMap.get(clientId).add(user);
                    } else {
                        ArrayList<User> users = new ArrayList<User>();
                        users.add(user);
                        this.userMap.put(clientId, users);
                    }
                }
                this.queryBeanMap.put(wikittyId, queries);
            }
            for (String clientId : this.userMap.keySet()) {
                if (clientMap.containsKey(clientId)) continue;
                try {
                    Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, clientId);
                    if (client == null) continue;
                    clientMap.put(client.getWikittyId(), client);
                    this.queryBeanMap.put(client.getWikittyId(), Collections.emptyList());
                }
                catch (WikittyException eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't restore client", (Throwable)eee);
                }
            }
            ArrayList clientList = new ArrayList(clientMap.values());
            ArrayList groupList = new ArrayList(groupMap.values());
            Collections.sort(clientList, VradiComparators.CLIENT_COMPARATOR);
            Collections.sort(groupList, VradiComparators.GROUP_COMPARATOR);
            this.topLevels.addAll(clientList);
            this.topLevels.addAll(groupList);
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof QueryMaker) {
                if (column == 0) {
                    QueryMaker queryMaker = (QueryMaker)node;
                    if (queryMaker instanceof Client) {
                        return ((Client)queryMaker).getName();
                    }
                    if (queryMaker instanceof User) {
                        return ((User)queryMaker).getName();
                    }
                    if (queryMaker instanceof Group) {
                        return ((Group)queryMaker).getName();
                    }
                }
            } else if (node instanceof QueryBean) {
                QueryBean bean = (QueryBean)node;
                if (column == 0) {
                    return bean.getName();
                }
                if (column == 1) {
                    return bean.getDescription();
                }
                if (column == 2) {
                    return bean.getQuery();
                }
            }
            return null;
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof Long) {
                return this.topLevels.get(index);
            }
            if (parent instanceof Client) {
                Client client = (Client)parent;
                String wikittyId = client.getWikittyId();
                if (this.userMap.containsKey(wikittyId)) {
                    List<User> users = this.userMap.get(wikittyId);
                    if (index < users.size()) {
                        return users.get(index);
                    }
                    List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                    QueryBean bean = list.get(index -= users.size());
                    return bean;
                }
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                QueryBean bean = list.get(index);
                return bean;
            }
            if (parent instanceof User) {
                User user = (User)parent;
                List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
                QueryBean bean = list.get(index);
                return bean;
            }
            if (parent instanceof Group) {
                Group group = (Group)parent;
                List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
                QueryBean bean = list.get(index);
                return bean;
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof Long) {
                return this.topLevels.size();
            }
            if (parent instanceof Client) {
                Client client = (Client)parent;
                String wikittyId = client.getWikittyId();
                if (this.userMap.containsKey(wikittyId)) {
                    List<User> users = this.userMap.get(wikittyId);
                    List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                    return users.size() + list.size();
                }
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                return list.size();
            }
            if (parent instanceof User) {
                User user = (User)parent;
                List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
                return list.size();
            }
            if (parent instanceof Group) {
                Group group = (Group)parent;
                List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
                return list.size();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof Long) {
                return this.topLevels.indexOf(child);
            }
            if (parent instanceof Client) {
                Client client = (Client)parent;
                String wikittyId = client.getWikittyId();
                List<User> users = this.userMap.get(wikittyId);
                if (child instanceof User) {
                    return users.indexOf(child);
                }
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                return users.size() + list.indexOf(child);
            }
            if (parent instanceof User) {
                User user = (User)parent;
                List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
                return list.indexOf(child);
            }
            if (parent instanceof Group) {
                Group group = (Group)parent;
                List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
                return list.indexOf(child);
            }
            return 0;
        }

        public String getColumnName(int column) {
            String columnName = null;
            if (column == 0) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.name");
            } else if (column == 1) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.description");
            } else if (column == 2) {
                columnName = I18n._((String)"vradi.requestFormView.resultTable.query");
            }
            return columnName;
        }
    }

    class QueryTreeTableModelListener
    implements TreeModelListener {
        final JXTreeTable treeTable;

        public QueryTreeTableModelListener(JXTreeTable treeTable) {
            this.treeTable = treeTable;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.treeTable.packAll();
        }
    }
}

