/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.query;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyException;

public class ThesaurusChangesTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(ThesaurusChangesTreeTableModel.class);
    final ArrayList<QueryMaker> topLevels = new ArrayList();
    final HashMap<String, List<User>> userMap = new HashMap();
    final HashMap<String, QueryMaker> queryMakersMap = new HashMap();
    final HashMap<String, List<QueryBean>> queryBeanMap = new HashMap();
    final HashMap<QueryBean, QueryBean> modifiedBeanMap = new HashMap();
    final HashMap<QueryBean, Boolean> queryBeanValidate = new HashMap();
    private VradiStorageService vradiStorageService = null;

    public ThesaurusChangesTreeTableModel(Map<QueryMaker, List<QueryBean>> queryMap, String before, String after) {
        super((Object)1L);
        HashMap<String, Client> clientMap = new HashMap<String, Client>();
        HashMap<String, User> userMap2 = new HashMap<String, User>();
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        for (Map.Entry<QueryMaker, List<QueryBean>> entry : queryMap.entrySet()) {
            QueryMaker queryMaker = entry.getKey();
            List<QueryBean> queries = entry.getValue();
            String wikittyId = queryMaker.getWikittyId();
            this.queryBeanMap.put(wikittyId, queries);
            if (queryMaker instanceof Client) {
                clientMap.put(wikittyId, (Client)queryMaker);
            } else if (queryMaker instanceof Group) {
                groupMap.put(wikittyId, (Group)queryMaker);
            } else if (queryMaker instanceof User) {
                userMap2.put(wikittyId, (User)queryMaker);
                User user = (User)queryMaker;
                String clientId = user.getClient();
                if (this.userMap.containsKey(clientId)) {
                    this.userMap.get(clientId).add(user);
                } else {
                    ArrayList<User> users = new ArrayList<User>();
                    users.add(user);
                    this.userMap.put(clientId, users);
                }
            }
            for (QueryBean original : queries) {
                String query = original.getQuery();
                query = before.indexOf(32) > 0 ? StringUtils.replace((String)query, (String)before, (String)after) : (after.indexOf(32) == -1 ? StringUtils.replace((String)query, (String)before, (String)after) : StringUtils.replace((String)query, (String)before, (String)("\"" + after + "\"")));
                QueryBean modified = original.setQuery(query);
                this.modifiedBeanMap.put(original, modified);
                this.queryBeanValidate.put(original, Boolean.TRUE);
            }
        }
        for (String clientId : this.userMap.keySet()) {
            if (clientMap.containsKey(clientId)) continue;
            try {
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, clientId);
                if (client == null) continue;
                clientMap.put(client.getWikittyId(), client);
                this.queryBeanMap.put(client.getWikittyId(), Collections.emptyList());
            }
            catch (WikittyException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        ArrayList clientList = new ArrayList(clientMap.values());
        ArrayList groupList = new ArrayList(groupMap.values());
        Collections.sort(clientList, VradiComparators.CLIENT_COMPARATOR);
        Collections.sort(groupList, VradiComparators.GROUP_COMPARATOR);
        this.topLevels.addAll(clientList);
        this.topLevels.addAll(groupList);
        this.queryMakersMap.putAll(clientMap);
        this.queryMakersMap.putAll(userMap2);
        this.queryMakersMap.putAll(groupMap);
    }

    public List<QueryMaker> getUpdatedQueryMakers() throws IOException {
        ArrayList<QueryMaker> list = new ArrayList<QueryMaker>();
        for (QueryMaker queryMaker : this.queryMakersMap.values()) {
            list.add(queryMaker);
            HashSet<String> queries = new HashSet<String>();
            Set<String> initialQueries = queryMaker.getQueries();
            if (initialQueries != null) {
                queries.addAll(initialQueries);
            }
            queryMaker.clearQueries();
            for (String query : queries) {
                QueryBean original = new QueryBean(query, queryMaker.getWikittyId());
                if (this.queryBeanValidate.containsKey(original) && this.queryBeanValidate.get(original).booleanValue()) {
                    QueryBean modified = this.modifiedBeanMap.get(original);
                    queryMaker.addQueries(modified.getQueryLine());
                    continue;
                }
                queryMaker.addQueries(query);
            }
        }
        return list;
    }

    public int getColumnCount() {
        return 5;
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof QueryMaker) {
            if (column == 0) {
                QueryMaker queryMaker = (QueryMaker)node;
                if (queryMaker instanceof Client) {
                    return ((Client)queryMaker).getName();
                }
                if (queryMaker instanceof User) {
                    return ((User)queryMaker).getName();
                }
                if (queryMaker instanceof Group) {
                    return ((Group)queryMaker).getName();
                }
            }
        } else if (node instanceof QueryBean) {
            QueryBean bean = (QueryBean)node;
            if (column == 0) {
                return bean.getName();
            }
            if (column == 1) {
                return bean.getDescription();
            }
            if (column == 2) {
                return bean.getQuery();
            }
            if (column == 3) {
                QueryBean modifiedBean = this.modifiedBeanMap.get(bean);
                return modifiedBean.getQuery();
            }
            if (column == 4) {
                boolean validate = this.queryBeanValidate.get(bean);
                return validate;
            }
        }
        return null;
    }

    public boolean isCellEditable(Object node, int column) {
        if (column == 3 || column == 4) {
            boolean b = node instanceof QueryBean;
            return b;
        }
        return false;
    }

    public void setValueAt(Object value, Object node, int column) {
        if (column == 3) {
            QueryBean modifiedBean;
            QueryBean bean = (QueryBean)node;
            String beanId = bean.getId();
            if (beanId == null) {
                return;
            }
            QueryBean initialBean = this.modifiedBeanMap.get(bean);
            if (!initialBean.equals((Object)(modifiedBean = initialBean.setQuery(String.valueOf(value))))) {
                this.modifiedBeanMap.put(bean, modifiedBean);
                this.queryBeanValidate.put(bean, Boolean.TRUE);
                this.fireQueryChanged(bean);
            }
        } else if (column == 4) {
            QueryBean bean = (QueryBean)node;
            String beanId = bean.getId();
            if (beanId == null) {
                return;
            }
            this.queryBeanValidate.put(bean, (Boolean)value);
            this.fireQueryChanged(bean);
        }
    }

    private void fireQueryChanged(QueryBean bean) {
        String beanId = bean.getId();
        TreePath parentPath = null;
        int index = 0;
        QueryMaker queryMaker = this.queryMakersMap.get(beanId);
        if (queryMaker instanceof User) {
            User user = (User)queryMaker;
            QueryMaker client = this.queryMakersMap.get(user.getClient());
            Object[] paths = new Object[]{1L, client, queryMaker};
            parentPath = new TreePath(paths);
            index = this.getIndexOfChild(paths[2], bean);
        } else {
            Object[] paths = new Object[]{1L, queryMaker};
            parentPath = new TreePath(paths);
            index = this.getIndexOfChild(paths[1], bean);
        }
        this.modelSupport.fireChildChanged(parentPath, index, (Object)bean);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof Long) {
            return this.topLevels.get(index);
        }
        if (parent instanceof Client) {
            Client client = (Client)parent;
            String wikittyId = client.getWikittyId();
            if (this.userMap.containsKey(wikittyId)) {
                List<User> users = this.userMap.get(wikittyId);
                if (index < users.size()) {
                    return users.get(index);
                }
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                QueryBean bean = list.get(index -= users.size());
                return bean;
            }
            List<QueryBean> list = this.queryBeanMap.get(wikittyId);
            QueryBean bean = list.get(index);
            return bean;
        }
        if (parent instanceof User) {
            User user = (User)parent;
            List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
            QueryBean bean = list.get(index);
            return bean;
        }
        if (parent instanceof Group) {
            Group group = (Group)parent;
            List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
            QueryBean bean = list.get(index);
            return bean;
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof Long) {
            return this.topLevels.size();
        }
        if (parent instanceof Client) {
            Client client = (Client)parent;
            String wikittyId = client.getWikittyId();
            if (this.userMap.containsKey(wikittyId)) {
                List<User> users = this.userMap.get(wikittyId);
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                return users.size() + list.size();
            }
            List<QueryBean> list = this.queryBeanMap.get(wikittyId);
            return list.size();
        }
        if (parent instanceof User) {
            User user = (User)parent;
            List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
            return list.size();
        }
        if (parent instanceof Group) {
            Group group = (Group)parent;
            List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
            return list.size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Long) {
            return this.topLevels.indexOf(child);
        }
        if (parent instanceof Client) {
            Client client = (Client)parent;
            String wikittyId = client.getWikittyId();
            if (this.userMap.containsKey(wikittyId)) {
                List<User> users = this.userMap.get(wikittyId);
                if (child instanceof User) {
                    return users.indexOf(child);
                }
                List<QueryBean> list = this.queryBeanMap.get(wikittyId);
                return users.size() + list.indexOf(child);
            }
            List<QueryBean> list = this.queryBeanMap.get(wikittyId);
            return list.indexOf(child);
        }
        if (parent instanceof User) {
            User user = (User)parent;
            List<QueryBean> list = this.queryBeanMap.get(user.getWikittyId());
            return list.indexOf(child);
        }
        if (parent instanceof Group) {
            Group group = (Group)parent;
            List<QueryBean> list = this.queryBeanMap.get(group.getWikittyId());
            return list.indexOf(child);
        }
        return -1;
    }

    public String getColumnName(int column) {
        String columnName = null;
        if (column == 0) {
            columnName = I18n._((String)"vradi.requestFormView.resultTable.name");
        } else if (column == 1) {
            columnName = I18n._((String)"vradi.requestFormView.resultTable.description");
        } else if (column == 2) {
            columnName = I18n._((String)"vradi.requestFormView.resultTable.oldQuery");
        } else if (column == 3) {
            columnName = I18n._((String)"vradi.requestFormView.resultTable.newQuery");
        }
        return columnName;
    }

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }
}

