/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.EntityHelper;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.WebHarvestStreamImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminUserUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.util.Date;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;

public enum AdminBeanConstant {
    CLIENT(I18n.n_((String)"vradi.client.category"), I18n.n_((String)"vradi.adminClient.newClientName"), Client.class, AdminClientUI.class),
    GROUP(I18n.n_((String)"vradi.group.category"), I18n.n_((String)"vradi.adminGroup.newGroupName"), Group.class, AdminGroupUI.class),
    USER(I18n.n_((String)"vradi.user.category"), I18n.n_((String)"vradi.adminUser.newUserName"), User.class, AdminUserUI.class),
    STATUS(I18n.n_((String)"vradi.status.category"), I18n.n_((String)"vradi.adminStatus.newStatusName"), Status.class, AdminStatusUI.class),
    XML_STREAM(I18n.n_((String)"vradi.stream.category"), I18n.n_((String)"vradi.adminXmlStream.newStreamName"), XmlStream.class, AdminXmlStreamUI.class),
    WEB_HARVEST_STREAM(I18n.n_((String)"vradi.stream.category"), I18n.n_((String)"vradi.adminXmlStream.newWebHarvestStreamName"), WebHarvestStream.class, AdminXmlStreamUI.class),
    FORM_TYPE(I18n.n_((String)"vradi.formType.category"), I18n.n_((String)"vradi.adminXmlStream.newFormTypeName"), WikittyExtension.class, AdminFormTypeUI.class);

    private String categoryName;
    private String newEntityName;
    private Class<?> beanClass;
    private Class<?> uiClass;

    private AdminBeanConstant(String categoryName, String newEntityName, Class<?> beanClass, Class<?> uiClass) {
        this.categoryName = categoryName;
        this.newEntityName = newEntityName;
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getNewEntityName() {
        return I18n._((String)this.newEntityName);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Class<?> getUIClass() {
        return this.uiClass;
    }

    public static AdminBeanConstant getConstantByUIClass(Class uiClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!uiClass.equals(constant.getUIClass())) continue;
            return constant;
        }
        return null;
    }

    public static AdminBeanConstant getConstantByBeanClass(Class beanClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant;
        }
        return null;
    }

    public Object getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        BusinessEntity result = null;
        switch (this) {
            case CLIENT: {
                if (id == null) {
                    ClientImpl newClient = new ClientImpl();
                    newClient.setName(this.getNewEntityName());
                    result = newClient;
                    break;
                }
                result = proxy.restore(Client.class, id);
                break;
            }
            case GROUP: {
                if (id == null) {
                    GroupImpl newGroup = new GroupImpl();
                    newGroup.setName(this.getNewEntityName());
                    result = newGroup;
                    break;
                }
                result = proxy.restore(Group.class, id);
                break;
            }
            case USER: {
                if (id == null) {
                    UserImpl newUser = new UserImpl();
                    newUser.setCreationDate(new Date());
                    newUser.setInscriptionDate(new Date());
                    newUser.setName(this.getNewEntityName());
                    newUser.setEnable(true);
                    result = newUser;
                    break;
                }
                result = proxy.restore(User.class, id);
                break;
            }
            case FORM_TYPE: {
                WikittyService wikittyService = proxy.getWikittyService();
                result = wikittyService.restoreExtension(proxy.getSecurityToken(), id);
                break;
            }
            case XML_STREAM: {
                if (id == null) {
                    XmlStreamImpl newXmlStream = new XmlStreamImpl();
                    newXmlStream.setName(this.getNewEntityName());
                    result = newXmlStream;
                    break;
                }
                result = proxy.restore(XmlStream.class, id);
                break;
            }
            case WEB_HARVEST_STREAM: {
                if (id == null) {
                    WebHarvestStreamImpl newWebHarvest = new WebHarvestStreamImpl();
                    newWebHarvest.setName(I18n._((String)this.getNewEntityName()));
                    result = newWebHarvest;
                    break;
                }
                result = proxy.restore(WebHarvestStream.class, id);
            }
        }
        if (result != null && result instanceof BusinessEntity) {
            EntityHelper.addModificationTagsIfNecessary(result);
        }
        return result;
    }

    public static Class<?> getUIClass(String categoryName) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!categoryName.equals(constant.getCategoryName())) continue;
            return constant.getUIClass();
        }
        return null;
    }

    public static Class<?> getUIClass(Class<?> beanClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant.getUIClass();
        }
        return null;
    }
}

