/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tree.TreeFilter;
import org.nuiton.wikitty.WikittyExtension;

public class AdminNavTreeFilter
implements TreeFilter {
    private static final Log log = LogFactory.getLog(AdminNavTreeFilter.class);
    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public boolean include(TreeModel model, Object node) {
        XmlStream xmlStream;
        if (StringUtils.isEmpty((String)this.filterString)) {
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Todo filter string : " + this.filterString + " on " + node));
        }
        boolean result = true;
        VradiTreeNode vradiNode = (VradiTreeNode)((Object)node);
        String wikittyId = vradiNode.getId();
        Class nodeType = vradiNode.getInternalClass();
        if (vradiNode.isStringNode()) {
            result = true;
        } else if (nodeType.equals(Client.class)) {
            Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, wikittyId);
            if (!client.getName().toLowerCase().contains(this.filterString)) {
                result = false;
                for (int i = 0; i < vradiNode.getChildCount() && !result; ++i) {
                    VradiTreeNode child = (VradiTreeNode)vradiNode.getChildAt(i);
                    result = this.include(model, (Object)child);
                }
            }
        } else if (nodeType.equals(User.class)) {
            Group group;
            VradiTreeNode clientNode;
            User user = (User)VradiService.getWikittyProxy().restore(User.class, wikittyId);
            if (!user.getName().toLowerCase().contains(this.filterString)) {
                result = false;
            }
            if ((clientNode = (VradiTreeNode)((VradiTreeNode)vradiNode.getParent()).getParent()).getInternalClass().equals(Client.class)) {
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, wikittyId);
                if (client.getName().toLowerCase().contains(this.filterString)) {
                    result = true;
                }
            } else if (clientNode.getInternalClass().equals(Group.class) && (group = (Group)VradiService.getWikittyProxy().restore(Group.class, wikittyId)).getName().toLowerCase().contains(this.filterString)) {
                result = true;
            }
        } else if (nodeType.equals(Group.class)) {
            Group group = (Group)VradiService.getWikittyProxy().restore(Group.class, wikittyId);
            if (!group.getName().toLowerCase().contains(this.filterString)) {
                result = false;
                for (int i = 0; i < vradiNode.getChildCount() && !result; ++i) {
                    VradiTreeNode child = (VradiTreeNode)vradiNode.getChildAt(i);
                    result = this.include(model, (Object)child);
                }
            }
        } else if (nodeType.equals(WikittyExtension.class)) {
            String token = VradiService.getWikittyProxy().getSecurityToken();
            WikittyExtension form = VradiService.getWikittyService().restoreExtension(token, wikittyId);
            if (!form.getName().toLowerCase().contains(this.filterString)) {
                result = false;
            }
        } else if (nodeType.equals(XmlStream.class) && !(xmlStream = (XmlStream)VradiService.getWikittyProxy().restore(XmlStream.class, wikittyId)).getName().toLowerCase().contains(this.filterString)) {
            result = false;
        }
        return result;
    }
}

