/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Like;
import org.nuiton.wikitty.search.Search;

public class ThesaurusManager {
    private static final Log log = LogFactory.getLog(ThesaurusManager.class);
    protected final WikittyProxy proxy;

    public ThesaurusManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public List<RootThesaurus> getRootThesaurus() throws VradiException {
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "RootThesaurus").criteria();
        PagedResult rootThesaurusResult = this.proxy.findAllByCriteria(RootThesaurus.class, criteria);
        List rootThesaurus = rootThesaurusResult.getAll();
        if (log.isInfoEnabled()) {
            log.info((Object)("Root thesaurus found : " + rootThesaurus.size()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Root thesaurus list : " + rootThesaurus));
            }
        }
        return rootThesaurus;
    }

    public List<Thesaurus> getAllThesaurus() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllThesaurus()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        PagedResult findAllByCriteria = this.proxy.findAllByCriteria(Thesaurus.class, criteria);
        List nodes = findAllByCriteria.getAll();
        log.info((Object)String.format("found %s thesaurus entries", nodes.size()));
        return nodes;
    }

    public Thesaurus getThesaurus(String thesaurusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusId + ")"));
        }
        Thesaurus node = (Thesaurus)this.proxy.restore(Thesaurus.class, thesaurusId);
        return node;
    }

    public List<Thesaurus> getThesaurus(List<String> thesaurusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusIds + ")"));
        }
        List nodes = this.proxy.restore(Thesaurus.class, thesaurusIds);
        return nodes;
    }

    public List<Thesaurus> getChildrenThesaurus(String thesaurusId) throws VradiException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getChildrenThesaurus(" + thesaurusId + ")"));
        }
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query.eq("TreeNode.parent", thesaurusId);
        Criteria criteria = query.criteria();
        PagedResult nodes = this.proxy.findAllByCriteria(Thesaurus.class, criteria);
        List all = nodes.getAll();
        return all;
    }

    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        Map.Entry entry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getNbFormsForThesaurus(" + thesaurusId + ")"));
        }
        if ((entry = this.proxy.restoreNode(Thesaurus.class, thesaurusId, null)) == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    public List<Thesaurus> proposeThesaurus(Form form) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proposeThesaurus(form)");
        }
        if (form == null) {
            return null;
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").eq("Infogene.id", form.getId()).criteria();
        List<Thesaurus> nodes = this.getAllThesaurus();
        Set formNodes = form.getThesaurus();
        for (Thesaurus node : nodes) {
            Set tags;
            if (formNodes != null && formNodes.contains(node.getWikittyId()) || (tags = node.getTags()) == null || tags.isEmpty()) continue;
            Search tagSearch = Search.query((Search.KIND)Search.KIND.OR);
            for (String string : tags) {
                if (string.isEmpty()) continue;
                tagSearch.keyword(string);
            }
            Criteria facetCriteria = tagSearch.criteria(node.getWikittyId());
            criteria.addFacetCriteria(facetCriteria);
        }
        PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
        List<Thesaurus> result = new ArrayList<Thesaurus>();
        if (forms != null && forms.getNumFound() > 0) {
            ArrayList<String> thesaurusIds = new ArrayList<String>();
            Map facetsMap = forms.getFacets();
            block2: for (Map.Entry entry : facetsMap.entrySet()) {
                List facetTopics = (List)entry.getValue();
                for (FacetTopic facetTopic : facetTopics) {
                    if (facetTopic.getCount() <= 0) continue;
                    thesaurusIds.add(facetTopic.getTopicName());
                    continue block2;
                }
            }
            if (!thesaurusIds.isEmpty()) {
                result = this.getThesaurus(thesaurusIds);
            }
        }
        return result;
    }

    public Map<Group, List<QueryBean>> getQueriesToModifyAfterThesaurusModification(String rootThesaurusName, String thesaurusName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getQueriesToModifyAfterThesaurusModification(" + rootThesaurusName + ", " + thesaurusName + ")"));
        }
        HashMap<Group, List<QueryBean>> results = new HashMap<Group, List<QueryBean>>();
        if (rootThesaurusName == null) {
            return results;
        }
        String requestPart = rootThesaurusName + ":" + (thesaurusName == null ? "" : thesaurusName);
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Group").like("QueryMaker.queries", requestPart, Like.SearchAs.AsText).criteria();
        PagedResult pagedResult = this.proxy.findAllByCriteria(Group.class, criteria);
        List groups = pagedResult.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[getQueriesToModifyAfterThesaurusModification]  " + groups.size() + "Groups found for request part requestPart : " + requestPart));
        }
        for (Group group : groups) {
            Set queries = group.getQueries();
            ArrayList<QueryBean> queriesToModify = new ArrayList<QueryBean>();
            for (String query : queries) {
                try {
                    QueryBean queryBean = new QueryBean(query, group.getWikittyId());
                    FilterList filter = VradiQueryParser.parse(queryBean.getQuery());
                    if (!this.isThesaurusInQuery(filter, rootThesaurusName, thesaurusName)) continue;
                    queriesToModify.add(queryBean);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (queriesToModify.isEmpty()) continue;
            results.put(group, queriesToModify);
        }
        return results;
    }

    boolean isThesaurusInQuery(FilterList list, String rootThesaurusName, String thesaurusName) {
        boolean insideQuery = false;
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                insideQuery = this.isThesaurusInQuery((FilterList)filter, rootThesaurusName, thesaurusName);
            } else if (filter instanceof CompareFilter) {
                insideQuery = this.isThesaurusInQuery((CompareFilter)filter, rootThesaurusName, thesaurusName);
            }
            if (!insideQuery) continue;
            break;
        }
        return insideQuery;
    }

    boolean isThesaurusInQuery(CompareFilter compareFilter, String rootThesaurusName, String thesaurusName) {
        boolean result;
        String name = compareFilter.getName();
        String value = compareFilter.getValue();
        boolean bl = result = rootThesaurusName.equals(name) && (thesaurusName == null || thesaurusName.equals(value));
        if (log.isDebugEnabled()) {
            log.debug((Object)("[isThesaurusInQuery] Root Thesaurus name : " + rootThesaurusName + " name : " + name + " ThesaurusName : " + thesaurusName + " value : " + value + " result : " + result));
        }
        return result;
    }

    void replaceThesaurusInQuery(FilterList list, String oldRootThesaurusName, String newRootThesaurusName, String oldThesaurusName, String newThesaurusName) {
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.replaceThesaurusInQuery((FilterList)filter, oldRootThesaurusName, newRootThesaurusName, oldThesaurusName, newThesaurusName);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.replaceThesaurusInQuery((CompareFilter)filter, oldRootThesaurusName, newRootThesaurusName, oldThesaurusName, newThesaurusName);
        }
    }

    void replaceThesaurusInQuery(CompareFilter compareFilter, String oldRootThesaurusName, String newRootThesaurusName, String oldThesaurusName, String newThesaurusName) {
        String name;
        String value = compareFilter.getValue();
        if (value.equals(oldThesaurusName) && oldRootThesaurusName.equals(name = compareFilter.getName())) {
            compareFilter.setName(newRootThesaurusName);
            compareFilter.setValue(newThesaurusName);
        }
    }
}

