/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTagImpl;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtils;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class FormManager {
    private static final Log log = LogFactory.getLog(FormManager.class);
    private final WikittyProxy proxy;
    private final ThesaurusManager thesaurusManager;
    private final SearchManager searchManager;

    public FormManager(WikittyProxy proxy, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.proxy = proxy;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public List<Form> updateForms(List<Form> forms) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForms(forms)");
        }
        if (forms == null || forms.isEmpty()) {
            return forms;
        }
        ArrayList<Thesaurus> thesaurusList = new ArrayList<Thesaurus>();
        for (Form form : forms) {
            Set thesaurus;
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating form: " + form.getId()));
            }
            Date now = new Date();
            if (form.getCreationDate() == null) {
                form.setCreationDate(now);
            } else {
                if (!form.getExtensionNames().contains("ModificationTag")) {
                    BusinessEntityWikitty businessEntityWikitty = (BusinessEntityWikitty)form;
                    Wikitty wikitty = businessEntityWikitty.getWikitty();
                    wikitty.addExtension(ModificationTagImpl.extensionModificationTag);
                }
                form.setField("ModificationTag", "lastModified", (Object)now);
            }
            if ((thesaurus = form.getThesaurus()) == null) continue;
            for (String thesaurusId : thesaurus) {
                Thesaurus node = this.thesaurusManager.getThesaurus(thesaurusId);
                if (node.getChildren() != null && node.getChildren().contains(form.getWikittyId())) continue;
                node.addChildren(form.getWikittyId());
                if (thesaurusList.contains(node)) continue;
                thesaurusList.add(node);
            }
        }
        List result = this.proxy.store(forms);
        if (!thesaurusList.isEmpty()) {
            this.proxy.store(thesaurusList);
        }
        return result;
    }

    public Session getLastCloseSession() {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.or().eq("Session.status", String.valueOf(VradiConstants.SessionStatus.CANCELED.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.SENT.getValue())).criteria();
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.proxy.findAllByCriteria(Session.class, criteria);
        if (result == null || result.size() == 0) {
            return null;
        }
        return (Session)result.getFirst();
    }

    public Session getLastOpenSession() throws VradiException {
        Session lastClose = this.getLastCloseSession();
        String formatedLastCloseDate = null;
        if (lastClose != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last closed session : " + lastClose.getSessionDate()));
            }
            try {
                formatedLastCloseDate = WikittyUtil.formatDate((Date)lastClose.getSessionDate());
            }
            catch (ParseException e) {
                log.error((Object)"Cant parse date");
            }
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        if (formatedLastCloseDate != null) {
            search.ge("Session.sessionDate", formatedLastCloseDate);
        }
        search.or().eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ACTIVE.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.STOPPED.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ERROR.getValue()));
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.proxy.findAllByCriteria(Session.class, criteria);
        Session session = null;
        if (result != null && result.size() > 0) {
            session = (Session)result.getFirst();
        }
        if (log.isDebugEnabled() && session != null) {
            log.debug((Object)("Last sessions found : " + session.getWikittyId() + " - " + session.getSessionDate() + " with status : " + session.getStatus()));
        }
        return session;
    }

    public List<Session> getSessions(Date sessionDate) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date " + sessionDate.toString()));
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.bw("Session.sessionDate", FormManager.getBeginOfDaySolrDate(sessionDate), FormManager.getEndOfDaySolrDate(sessionDate));
        Criteria criteria = search.criteria();
        List allSession = this.proxy.findAllByCriteria(Session.class, criteria).getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(allSession.size() + " sessions found"));
        }
        return allSession;
    }

    protected static String getBeginOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtils.setMinTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    protected static String getEndOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtils.setMaxTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    public Session createNewSession() throws VradiException {
        Session lastSession = this.getLastOpenSession();
        if (lastSession != null) {
            throw new VradiException(I18n._((String)"Already opened session"));
        }
        Date now = new Date();
        List<Session> sessionList = this.getSessions(now);
        int num = sessionList.size() + 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("No session found, creating a new one with num : " + num));
        }
        SessionImpl currentSession = new SessionImpl();
        currentSession.setSessionDate(now);
        currentSession.setNum(num);
        currentSession.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        currentSession.setParagraph(Configuration.getInstance().getSessionDefaultParagraph());
        currentSession = (Session)this.proxy.store((BusinessEntity)currentSession);
        return currentSession;
    }

    public Session bindForms(Session currentSession) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("bindForms " + currentSession.getSessionDate()));
        }
        try {
            List<Sending> toSend = this.findAllUnboundForms(currentSession);
            Session reloadedSession = (Session)this.proxy.restore(Session.class, currentSession.getWikittyId());
            if (reloadedSession != null) {
                currentSession = reloadedSession;
            }
            for (Sending s : toSend) {
                currentSession.addSending(s.getWikittyId());
            }
            currentSession = (Session)this.proxy.store((BusinessEntity)currentSession);
            if (log.isDebugEnabled()) {
                int size = currentSession.getSending() == null || currentSession.getSending().isEmpty() ? 0 : currentSession.getSending().size();
                log.debug((Object)("Saving session '" + currentSession.getSessionDate() + "' number '" + currentSession.getNum() + "' status '" + VradiConstants.SessionStatus.getStatus(currentSession.getStatus()).getDescription() + "' with '" + size + "' sending"));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't bind form : ", (Throwable)e);
            }
            throw new VradiException("Can't bind form : ", e);
        }
        return currentSession;
    }

    protected List<Sending> findAllUnboundForms(Session currentSession) throws VradiException {
        Status status = this.getSelectionneStatus();
        ArrayList<Sending> toSend = new ArrayList<Sending>();
        List<Group> groups = this.searchManager.findGroupsWithQueries();
        for (Group group : groups) {
            ArrayList<Form> formsToBind = new ArrayList<Form>();
            Set queries = group.getQueries();
            for (String queryEntry : queries) {
                try {
                    QueryBean queryBean = new QueryBean(queryEntry);
                    String query = queryBean.getQuery();
                    FormPagedResult vradiFormPage = new FormPagedResult();
                    Date olderInscriptionDate = this.getOlderInscriptionDate((QueryMaker)group);
                    vradiFormPage = this.searchManager.findForms(query, vradiFormPage, "Form.datePub", olderInscriptionDate, status.getWikittyId());
                    List<Form> resultForms = vradiFormPage.getFormsToShow();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Query " + query + " return " + resultForms.size() + " forms"));
                    }
                    formsToBind.addAll(resultForms);
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't parse group query", (Throwable)ex);
                }
                catch (UnsupportedQueryException ex) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't execute group query", (Throwable)ex);
                }
            }
            if (formsToBind.isEmpty()) continue;
            List<Sending> sendings = this.createAllSending(currentSession, (QueryMaker)group, formsToBind, true);
            toSend.addAll(sendings);
        }
        return toSend;
    }

    protected Date getOlderInscriptionDate(QueryMaker queryMaker) {
        Date result = new Date();
        if (queryMaker instanceof User) {
            User user = (User)queryMaker;
            Date inscriptionDate = user.getInscriptionDate();
            if (inscriptionDate != null && result.after(DateUtils.setMinTimeOfDay((Date)inscriptionDate))) {
                result = inscriptionDate;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The older inscription date for user " + user.getName() + " is " + result));
            }
        }
        if (queryMaker instanceof Group) {
            Group group = (Group)queryMaker;
            Set userIds = group.getUser();
            if (userIds != null) {
                for (String userId : userIds) {
                    User user = (User)this.proxy.restore(User.class, userId);
                    Date inscriptionDate = this.getOlderInscriptionDate((QueryMaker)user);
                    if (inscriptionDate == null || !result.after(inscriptionDate)) continue;
                    result = inscriptionDate;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The older inscription date for group " + group.getName() + " is " + result));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The older inscription date " + result));
        }
        return result;
    }

    public List<Sending> createAllSending(Session currentSession, QueryMaker queryMaker, List<? extends Form> formsToBind, boolean removeAlreadyBind) {
        List<Object> result = new ArrayList<Sending>();
        currentSession = (Session)this.proxy.restore(Session.class, currentSession.getWikittyId());
        Sending sending = this.findExistingOrCreateSending(currentSession, queryMaker);
        if (queryMaker instanceof User) {
            sending.setUser(queryMaker.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add user " + queryMaker.getWikittyId()));
            }
        } else if (queryMaker instanceof Group) {
            Set usersIds;
            sending.setGroup(queryMaker.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add group " + queryMaker.getWikittyId()));
            }
            if ((usersIds = ((Group)queryMaker).getUser()) != null) {
                for (String string : usersIds) {
                    User user = (User)this.proxy.restore(User.class, string);
                    if (user == null) continue;
                    List<Sending> userSending = this.createAllSending(currentSession, (QueryMaker)user, formsToBind, removeAlreadyBind);
                    result.addAll(userSending);
                }
            }
        }
        if (removeAlreadyBind) {
            formsToBind = this.removeAlreadyBound(currentSession, formsToBind, queryMaker);
            if (queryMaker instanceof User) {
                User user = (User)queryMaker;
                Date date = user.getInscriptionDate();
                for (Form form : new ArrayList<Form>(formsToBind)) {
                    Date formCreationDate = form.getCreationDate();
                    if (user.getEnable() && !formCreationDate.before(date)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing form '" + form.getObjet() + "' because date of creation (" + formCreationDate + ") is before user inscription date (" + date + ") for user : " + user.getName()));
                    }
                    formsToBind.remove(form);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding " + formsToBind.size() + " forms to sending"));
            }
        }
        for (Form form : formsToBind) {
            String string = form.getWikittyId();
            sending.removeForm(string);
            sending.addForm(string);
        }
        Set formsAttached = sending.getForm();
        if (formsAttached != null && !formsAttached.isEmpty()) {
            result.add(sending);
        }
        if (!result.isEmpty()) {
            currentSession = (Session)this.proxy.restore(Session.class, currentSession.getWikittyId());
            for (Sending sending2 : result) {
                currentSession.addSending(sending2.getWikittyId());
            }
            result = this.proxy.store(result);
            this.proxy.store((BusinessEntity)currentSession);
        }
        return result;
    }

    public List<Sending> removeAllSending(Session session, Form form, QueryMaker queryMaker) {
        Set userIds;
        Set sendingList = session.getSending();
        ArrayList sendingArray = new ArrayList();
        if (sendingList != null) {
            sendingArray = new ArrayList(sendingList);
        }
        List sendings = this.proxy.restore(Sending.class, sendingArray);
        ArrayList<String> impacted = new ArrayList<String>();
        impacted.add(queryMaker.getWikittyId());
        if (queryMaker instanceof Group && (userIds = ((Group)queryMaker).getUser()) != null) {
            for (String userId : userIds) {
                impacted.add(userId);
            }
        }
        ArrayList<Sending> sendingImpacted = new ArrayList<Sending>();
        for (Sending sending : sendings) {
            if (sending.getForm().contains(form.getWikittyId()) && (impacted.contains(sending.getUser()) || impacted.contains(sending.getGroup()))) {
                sending.removeForm(form.getWikittyId());
                sending.addDeletedForms(form.getWikittyId());
                sendingImpacted.add(sending);
            }
            if (!sending.getForm().isEmpty()) continue;
            sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
        }
        this.proxy.store(sendingImpacted);
        List result = this.proxy.restore(Sending.class, sendingArray);
        return result;
    }

    protected Sending findExistingOrCreateSending(Session currentSession, QueryMaker queryMaker) {
        Set sendingsId = currentSession.getSending();
        List sendings = null;
        sendings = sendingsId != null ? this.proxy.restore(Sending.class, new ArrayList(sendingsId)) : new ArrayList();
        for (Sending sending : sendings) {
            String qmId = queryMaker.getWikittyId();
            if (!qmId.equals(sending.getUser()) && (!qmId.equals(sending.getGroup()) || sending.getStatus() == VradiConstants.SendingStatus.DELETED.getValue())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending is existing for queryMaker : " + queryMaker));
            }
            return sending;
        }
        SendingImpl newSending = new SendingImpl();
        newSending.setSentDate(null);
        newSending.setReceptionDate(null);
        newSending.setParagraph("");
        newSending.setReceptionProof(false);
        newSending.setStatus(VradiConstants.SendingStatus.TO_SEND.getValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending dont exist for queryMaker : " + queryMaker + ", creating one"));
        }
        return newSending;
    }

    protected List<? extends Form> removeAlreadyBound(Session currentSession, List<? extends Form> forms, QueryMaker queryMaker) {
        ArrayList<String> formIds = new ArrayList<String>();
        for (Form form : forms) {
            formIds.add(form.getWikittyId());
        }
        String qmId = queryMaker.getWikittyId();
        Search search = Search.query().and();
        Set sendingIds = currentSession.getSending();
        if (sendingIds != null) {
            for (String currentSendingId : sendingIds) {
                search.neq(Element.ELT_ID, currentSendingId);
            }
        }
        search.or().contains("Sending.form", formIds).contains("Sending.deletedForms", formIds);
        search.or().eq("Sending.client", qmId).eq("Sending.user", qmId).eq("Sending.group", qmId);
        search.not().eq("Sending.status", String.valueOf(VradiConstants.SendingStatus.DELETED.getValue()));
        PagedResult pagedResult = this.proxy.findAllByCriteria(Sending.class, search.criteria());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove " + pagedResult.size() + " already bounds forms"));
        }
        for (Sending send : pagedResult.getAll()) {
            formIds.removeAll(send.getForm());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rest " + formIds.size() + " forms"));
        }
        List result = this.proxy.restore(Form.class, formIds);
        return result;
    }

    public Status getStatus(String statusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatus(" + statusId + ")"));
        }
        Status status = (Status)this.proxy.restore(Status.class, statusId);
        return status;
    }

    public List<Status> getStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getStatuses(statusIds)");
        }
        List statuses = this.proxy.restore(Status.class, statusIds);
        return new ArrayList<Status>(statuses);
    }

    public List<Status> createDefaultStatuses() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createDefaultStatuses()");
        }
        ArrayList<Status> all = new ArrayList<Status>();
        all.add(this.getNonTraiteStatus());
        all.add(this.getNonSelectionneStatus());
        all.add(this.getPreselectionneStatus());
        all.add(this.getSelectionneStatus());
        return new ArrayList<Status>(all);
    }

    public Status getNonTraiteStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_TRAITE);
    }

    public Status getNonSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_SELECTIONNE);
    }

    public Status getPreselectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.PRESELECTIONNE);
    }

    public Status getSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.SELECTIONNE);
    }

    protected Status getOrCreateStatus(VradiConstants.FormStatus type) {
        Search search;
        Criteria criteria;
        Status status;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOrCreateStatus(" + type.getName() + ")"));
        }
        if ((status = (Status)this.proxy.findByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status").eq("Status.name", type.getName())).criteria())) == null) {
            log.warn((Object)("Status not found creating : " + type.getName()));
            status = new StatusImpl();
            status.setName(type.getName());
            status.setValue(type.getValue());
            status.setDescription(type.getDescription());
            status.setModifiable(false);
            status = (Status)this.proxy.store((BusinessEntity)status);
        }
        return status;
    }

    public List<Status> updateStatuses(List<Status> statuses) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatuses(statuses)");
        }
        try {
            List result = this.proxy.store(statuses);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Cant update statuses : ", (Throwable)e);
            throw new VradiException("Cant update statuses : ", e);
        }
    }

    public Status updateStatus(Status status) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatus(status)");
        }
        try {
            status = (Status)this.proxy.store((BusinessEntity)status);
            return status;
        }
        catch (Exception e) {
            log.error((Object)"Cant update status : ", (Throwable)e);
            throw new VradiException("Cant update status : ", e);
        }
    }

    public void deleteStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteStatus(" + statusIds + ")"));
        }
        try {
            this.proxy.delete(statusIds);
        }
        catch (Exception e) {
            log.error((Object)"Cant delete status : ", (Throwable)e);
            throw new VradiException("Cant delete status : ", e);
        }
    }

    protected List<User> getUsersOfClient(String clientId) {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "User").eq("User.client", clientId);
        Criteria criteria = search.criteria();
        PagedResult usersPageResult = this.proxy.findAllByCriteria(User.class, criteria);
        return new ArrayList<User>(usersPageResult.getAll());
    }
}

