/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.ThesaurusCartography;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiDataServiceImpl
implements VradiDataService {
    private static final Log log = LogFactory.getLog(VradiDataServiceImpl.class);
    protected WikittyProxy wikittyProxy;
    protected ThesaurusManager thesaurusManager;
    protected SearchManager searchManager;
    protected FormManager formManager;

    public VradiDataServiceImpl(WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
        this.initManagers();
    }

    protected void initManagers() {
        this.thesaurusManager = new ThesaurusManager(this.wikittyProxy);
        this.searchManager = new SearchManager(this.wikittyProxy, this.thesaurusManager);
        this.formManager = new FormManager(this.wikittyProxy, this.thesaurusManager, this.searchManager);
    }

    protected <T extends BusinessEntity> List<T> findAllByExtension(Class<T> type, String extension, String ... sortFields) {
        Search search = Search.query().eq(Element.ELT_EXTENSION, extension);
        Criteria criteria = search.criteria();
        for (String sortField : sortFields) {
            criteria.addSortAscending(sortField);
        }
        PagedResult findAllByCriteria = this.wikittyProxy.findAllByCriteria(type, criteria);
        List results = findAllByCriteria.getAll();
        return new ArrayList(results);
    }

    @Override
    public List<Client> findAllClients() {
        return this.findAllByExtension(Client.class, "Client", "Client.name");
    }

    @Override
    public List<User> findAllUsers() {
        Search search = Search.query().eq("User.client", "*");
        Criteria criteria = search.criteria();
        PagedResult users = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        return new ArrayList<User>(users.getAll());
    }

    @Override
    public List<Group> findAllGroups() {
        return this.findAllByExtension(Group.class, "Group", "Group.name");
    }

    @Override
    public List<Status> createDefaultStatuses() throws VradiException {
        return this.formManager.createDefaultStatuses();
    }

    @Override
    public List<WebHarvestStream> findAllWebHarvest() {
        return this.findAllByExtension(WebHarvestStream.class, "WebHarvestStream", "XmlStream.name");
    }

    @Override
    public List<XmlStream> findAllXmlStreams() {
        return this.findAllByExtension(XmlStream.class, "XmlStream", "XmlStream.name");
    }

    @Override
    public List<Thesaurus> findAllThesaurus() {
        return this.findAllByExtension(Thesaurus.class, "Thesaurus", "TreeNode.name");
    }

    @Override
    public List<User> findClientUsers(String clientId) {
        Search search = Search.query().eq("User.client", clientId);
        Criteria criteria = search.criteria();
        criteria.addSortAscending("User.name");
        PagedResult usersResult = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        ArrayList<User> users = new ArrayList<User>(usersResult.getAll());
        return users;
    }

    @Override
    public WikittyExtension getFormType(String name) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormType(" + name + ")"));
        }
        try {
            WikittyService wikittyService = this.wikittyProxy.getWikittyService();
            WikittyExtension wikittyExtension = wikittyService.restoreExtensionLastVersion(null, name);
            return wikittyExtension;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get form type", (Throwable)eee);
            }
            throw new VradiException("Can't get form type", eee);
        }
    }

    @Override
    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) throws VradiException {
        WikittyExtension resultExtension;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + name + ", fields, requires, tagValues)"));
        }
        try {
            WikittyExtension lastVersion = this.getFormType(name);
            String newVersion = lastVersion != null ? WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()) : "0.0";
            resultExtension = new WikittyExtension(name, newVersion, requires, new LinkedHashMap<String, FieldType>(fields));
            if (tagValues != null) {
                for (Map.Entry<String, String> entry : tagValues.entrySet()) {
                    resultExtension.addTagValue(entry.getKey(), entry.getValue());
                }
            }
            List<WikittyExtension> extensions = Arrays.asList(resultExtension);
            this.wikittyProxy.getWikittyService().storeExtension(null, extensions);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("FormType named %s saved with id: %s and version: %s", name, resultExtension.getId(), newVersion));
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Update form type", (Throwable)eee);
            }
            throw new VradiException("Update form type", eee);
        }
        return resultExtension;
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + extension.toDefinition() + ")"));
        }
        try {
            LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
            for (String fieldName : extension.getFieldNames()) {
                FieldType fieldType = extension.getFieldType(fieldName);
                fields.put(fieldName, fieldType);
            }
            WikittyExtension updated = this.updateFormType(extension.getName(), fields, extension.getRequires(), extension.getTagValues());
            return updated;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't update form type", (Throwable)eee);
            }
            throw new VradiException("Can't update form type", eee);
        }
    }

    @Override
    public FormPagedResult findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, List<String> thesaurus, String[] statusIds, FormPagedResult formPagedResult) throws UnsupportedQueryException, VradiException {
        FormPagedResult result = this.searchManager.findForms(query, extension, dateType, beginDate, endDate, streamId, thesaurus, statusIds, formPagedResult);
        return result;
    }

    @Override
    public ThesaurusCartography getThesaurusCartography(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, List<String> thesaurus, String[] statusIds) throws VradiException, UnsupportedQueryException {
        ThesaurusCartography thesaurusCartography = this.searchManager.getThesaurusCartography(query, extension, dateType, beginDate, endDate, streamId, thesaurus, statusIds);
        return thesaurusCartography;
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings(bindings)");
        }
        try {
            ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
            if (bindings != null) {
                bindings = this.wikittyProxy.store(bindings);
                list.addAll(bindings);
            }
            return list;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't update xml field bindings", (Throwable)eee);
            }
            throw new VradiException("Can't update xml field bindings", eee);
        }
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() throws VradiException {
        ArrayList<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
        WikittyService wikittyService = this.wikittyProxy.getWikittyService();
        List allExtensionIds = wikittyService.getAllExtensionsRequires(null, "Form");
        HashMap<String, WikittyExtension> lastVersions = new HashMap<String, WikittyExtension>();
        for (String extensionId : allExtensionIds) {
            String extensionName = WikittyExtension.computeName((String)extensionId);
            if (lastVersions.get(extensionName) != null) continue;
            WikittyExtension extension = wikittyService.restoreExtensionLastVersion(null, extensionName);
            extension = this.computeExtension(extension);
            lastVersions.put(extensionName, extension);
        }
        extensions.addAll(lastVersions.values());
        return extensions;
    }

    protected WikittyExtension computeExtension(WikittyExtension extension) {
        String key;
        int i;
        Collection fieldNames = extension.getFieldNames();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        ArrayList<String> orderlessFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            try {
                Integer.valueOf(fieldType.getTagValue("rank"));
                fieldOrder.add(fieldName);
            }
            catch (Exception eee) {
                orderlessFields.add(fieldName);
            }
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        int size = fieldOrder.size();
        for (i = 0; i < size; ++i) {
            key = (String)fieldOrder.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        size = orderlessFields.size();
        for (i = 0; i < size; ++i) {
            key = (String)orderlessFields.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        WikittyExtension fieldOrderedExtension = new WikittyExtension(extension.getName(), extension.getVersion(), extension.getRequires(), fields);
        fieldOrderedExtension.setTagValues(extension.getTagValues());
        return fieldOrderedExtension;
    }

    @Override
    public List<RootThesaurus> getRootThesaurus() throws VradiException {
        return this.thesaurusManager.getRootThesaurus();
    }

    @Override
    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getNbFormsForThesaurus(thesaurusId);
    }

    @Override
    public List<Thesaurus> getChildrenThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getChildrenThesaurus(thesaurusId);
    }
}

