/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.SecurityTokenHelper;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyAuthorisationAbstract;
import org.nuiton.wikitty.WikittyAuthorisationHelper;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyGroupHelper;
import org.nuiton.wikitty.WikittyGroupImpl;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Search;

public class WikittyServiceSecurity
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceSecurity.class);
    public static final String WIKITTY_APPADMIN_GROUP_NAME = "WikittyAppAdmin";
    protected WikittyService ws;
    protected transient String appAdminGroupId = null;

    public WikittyServiceSecurity(WikittyService ws) {
        this.ws = ws;
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        String token = WikittyUtil.genSecurityToken();
        WikittyImpl wToken = new WikittyImpl(token);
        SecurityTokenHelper.addExtension(wToken);
        this.ws.store(null, wToken);
        return token;
    }

    @Override
    public void logout(String securityToken) {
        this.ws.delete(null, securityToken);
    }

    @Override
    public void clear(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            throw new SecurityException(I18n._((String)"user %s can't clear data", (Object[])new Object[]{this.getUserId(securityToken)}));
        }
        this.ws.clear(securityToken);
    }

    protected void prepareWrite(String securityToken, Wikitty wikitty) {
        Wikitty oldVersion = this.ws.restore(securityToken, wikitty.getId());
        if (oldVersion == null) {
            String userId = this.getUserId(securityToken);
            WikittyAuthorisationHelper.addExtension(wikitty);
            WikittyAuthorisationHelper.setOwner(wikitty, userId);
        }
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        boolean result = false;
        String userId = this.getUserId(securityToken);
        Wikitty oldVersion = this.ws.restore(securityToken, wikitty.getId());
        result = oldVersion == null ? true : this.isOwner(securityToken, userId, oldVersion) || this.isAppAdmin(securityToken, userId) || this.isAdmin(securityToken, userId, oldVersion) || WikittyAuthorisationAbstract.equals(oldVersion, wikitty) && this.isWriter(securityToken, userId, oldVersion);
        return result;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        String userId;
        boolean result = false;
        Wikitty oldVersion = this.ws.restore(securityToken, wikittyId);
        result = oldVersion == null ? true : this.isOwner(securityToken, userId = this.getUserId(securityToken), oldVersion) || this.isAppAdmin(securityToken, userId) || this.isAdmin(securityToken, userId, oldVersion);
        return result;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        Wikitty w;
        Wikitty securityTokenWikitty = this.ws.restore(securityToken, securityToken);
        String userId = SecurityTokenHelper.getUser(securityTokenWikitty);
        boolean result = this.isReader(securityToken, userId, w = this.ws.restore(securityToken, wikittyId)) || this.isOwner(securityToken, userId, w) || this.isAppAdmin(securityToken, userId) || this.isAdmin(securityToken, userId, w) || this.isWriter(securityToken, userId, w);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        if (this.canWrite(securityToken, wikitty)) {
            this.prepareWrite(securityToken, wikitty);
            UpdateResponse result = this.ws.store(securityToken, wikitty);
            return result;
        }
        throw new SecurityException(I18n._((String)"user %s can't modify object %s", (Object[])new Object[]{this.getUserId(securityToken), wikitty.getId()}));
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            if (this.canWrite(securityToken, w)) continue;
            throw new SecurityException(I18n._((String)"user %s can't modify object %s", (Object[])new Object[]{this.getUserId(securityToken), w.getId()}));
        }
        for (Wikitty w : wikitties) {
            this.prepareWrite(securityToken, w);
        }
        UpdateResponse result = this.ws.store(securityToken, wikitties);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        for (Wikitty w : wikitties) {
            if (this.canWrite(securityToken, w)) continue;
            throw new SecurityException(I18n._((String)"user %s can't modify object %s", (Object[])new Object[]{this.getUserId(securityToken), w.getId()}));
        }
        for (Wikitty w : wikitties) {
            this.prepareWrite(securityToken, w);
        }
        UpdateResponse result = this.ws.store(securityToken, wikitties, disableAutoVersionIncrement);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        for (Wikitty w : wikitties) {
            if (this.canWrite(securityToken, w)) continue;
            throw new SecurityException(I18n._((String)"user %s can't modify object %s", (Object[])new Object[]{this.getUserId(securityToken), w.getId()}));
        }
        for (Wikitty w : wikitties) {
            this.prepareWrite(securityToken, w);
        }
        UpdateResponse result = this.ws.store(securityToken, transaction, wikitties, disableAutoVersionIncrement);
        return result;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        return this.ws.storeExtension(securityToken, ext);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        return this.ws.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        return this.ws.storeExtension(securityToken, transaction, exts);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        Wikitty result = null;
        if (this.canRead(securityToken, id)) {
            result = this.ws.restore(securityToken, id);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"user %s can't read object %s", (Object[])new Object[]{this.getUserId(securityToken), id}));
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        LinkedList<String> authorizedIds = new LinkedList<String>(ids);
        Iterator i = authorizedIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (this.canRead(securityToken, id)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n._((String)"user %s can't read object %s, remove it in restore list", (Object[])new Object[]{this.getUserId(securityToken), id}));
            }
            i.remove();
        }
        return this.ws.restore(securityToken, authorizedIds);
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        LinkedList<String> authorizedIds = new LinkedList<String>(ids);
        Iterator i = authorizedIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (this.canRead(securityToken, id)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n._((String)"user %s can't read object %s, remove it in restore list", (Object[])new Object[]{this.getUserId(securityToken), id}));
            }
            i.remove();
        }
        return this.ws.restore(securityToken, transaction, authorizedIds);
    }

    @Override
    public void delete(String securityToken, String id) {
        if (this.canDelete(securityToken, id)) {
            this.ws.delete(securityToken, id);
        }
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        for (String id : ids) {
            if (this.canDelete(securityToken, id)) continue;
            throw new SecurityException(I18n._((String)"user %s can't delete object %s", (Object[])new Object[]{this.getUserId(securityToken), id}));
        }
        this.ws.delete(securityToken, ids);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, criteria);
        return result;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, transaction, criteria);
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        Wikitty result = this.ws.findByCriteria(securityToken, criteria);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        Wikitty result = this.ws.findByCriteria(securityToken, transaction, criteria);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public void addLabel(String securityToken, String wikittyId, String label) {
        this.ws.addLabel(securityToken, wikittyId, label);
    }

    @Override
    public PagedResult<String> findAllByLabel(String securityToken, String label, int firstIndex, int endIndex) {
        PagedResult<String> result = this.ws.findAllByLabel(securityToken, label, firstIndex, endIndex);
        return result;
    }

    @Override
    public Wikitty findByLabel(String securityToken, String label) {
        Wikitty result = this.ws.findByLabel(securityToken, label);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public Set<String> findAllAppliedLabels(String securityToken, String wikittyId) {
        Set<String> result = this.ws.findAllAppliedLabels(securityToken, wikittyId);
        return result;
    }

    @Override
    public Tree restoreTree(String securityToken, String wikittyId) {
        return this.ws.restoreTree(securityToken, wikittyId);
    }

    @Override
    public Map.Entry<TreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<TreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty result = this.ws.restoreVersion(securityToken, wikittyId, version);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            return this.ws.syncEngin(securityToken);
        }
        throw new SecurityException(I18n._((String)"user %s can't sync sear engine", (Object[])new Object[]{this.getUserId(securityToken)}));
    }

    protected PagedResult<Wikitty> checkPagedResult(PagedResult<Wikitty> pagedResult) {
        return pagedResult;
    }

    protected String getUserId(String securityToken) {
        String result = null;
        Wikitty securityTokenWikitty = this.ws.restore(securityToken, securityToken);
        if (securityTokenWikitty != null) {
            result = SecurityTokenHelper.getUser(securityTokenWikitty);
        }
        return result;
    }

    protected boolean isOwner(String securityToken, String userId, Wikitty w) {
        boolean result = false;
        if (WikittyAuthorisationHelper.isExtension(w)) {
            String owner = WikittyAuthorisationHelper.getOwner(w);
            result = userId.equals(owner);
        }
        return result;
    }

    protected boolean isAdmin(String securityToken, String userId, Wikitty w) {
        boolean result = this.isMember(securityToken, userId, w, "Admin");
        return result;
    }

    protected boolean isWriter(String securityToken, String userId, Wikitty w) {
        boolean result = this.isMember(securityToken, userId, w, "Writer");
        return result;
    }

    protected boolean isReader(String securityToken, String userId, Wikitty w) {
        boolean result = true;
        if (WikittyAuthorisationHelper.isExtension(w)) {
            Set<String> groupOrUser = WikittyAuthorisationHelper.getReader(w);
            if (groupOrUser == null || groupOrUser.size() == 0) {
                String parentId = WikittyAuthorisationHelper.getParent(w);
                if (parentId != null) {
                    Wikitty parent = this.ws.restore(securityToken, parentId);
                    result = this.isReader(securityToken, userId, parent);
                }
            } else {
                result = this.isMember(securityToken, userId, w, "Reader");
            }
        }
        return result;
    }

    protected boolean isAppAdmin(String securityToken, String userId) {
        Wikitty group = this.appAdminGroupId == null ? this.ws.findByCriteria(securityToken, Search.query().eq("WikittyGroup.name", WIKITTY_APPADMIN_GROUP_NAME).criteria()) : this.ws.restore(securityToken, this.appAdminGroupId);
        if (group == null) {
            WikittyGroupImpl appAdminGroup = new WikittyGroupImpl();
            appAdminGroup.setName(WIKITTY_APPADMIN_GROUP_NAME);
        }
        this.appAdminGroupId = group.getId();
        Set<String> ids = WikittyGroupHelper.getMembers(group);
        boolean result = this.isMember(securityToken, userId, ids);
        return result;
    }

    protected boolean isMember(String securityToken, String userId, Wikitty w, String field) {
        String parentId;
        Set<String> groupOrUser;
        boolean result = false;
        if (WikittyAuthorisationHelper.isExtension(w) && !(result = this.isMember(securityToken, userId, groupOrUser = w.getFieldAsSet("WikittyAuthorisation", field, String.class))) && (parentId = WikittyAuthorisationHelper.getParent(w)) != null) {
            Wikitty parent = this.ws.restore(securityToken, parentId);
            result = this.isMember(securityToken, userId, parent, field);
        }
        return result;
    }

    protected boolean isMember(String securityToken, String userId, Set<String> groupOrUser) {
        boolean result = false;
        if (groupOrUser != null) {
            for (String id : groupOrUser) {
                Set<String> members;
                if (userId.equals(id)) {
                    result = true;
                    break;
                }
                Wikitty w = this.ws.restore(securityToken, id);
                if (!WikittyGroupHelper.isExtension(w) || !this.isMember(securityToken, userId, members = WikittyGroupHelper.getMembers(w))) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

