/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyServiceNotifier;

public class JGroupsNotifier
extends ReceiverAdapter
implements WikittyServiceListener {
    private static Log log = LogFactory.getLog(JGroupsNotifier.class);
    protected WikittyServiceNotifier ws;
    protected boolean propagateCache = false;
    protected JChannel channel;

    public JGroupsNotifier(WikittyServiceNotifier ws, String channelName, boolean propagateCache) {
        this.ws = ws;
        this.propagateCache = propagateCache;
        this.initChannel(channelName);
    }

    protected void initChannel(String channelName) {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Init jgroup communication channel...");
            }
            try {
                this.channel = new JChannel();
                this.channel.connect(channelName);
                this.channel.setReceiver((Receiver)this);
                this.channel.setOpt(3, (Object)false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JGroup communication channel initialized to " + this.channel.getAddressAsString()));
                }
            }
            catch (ChannelException eee) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't init jgroup channel");
            }
        }
    }

    protected void sendJGroupMessage(WikittyJGroupMessage wikittyMessage) {
        block5: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Send message : " + wikittyMessage));
            }
            Message msg = new Message(null, null, (Serializable)wikittyMessage);
            try {
                this.channel.send(msg);
            }
            catch (ChannelNotConnectedException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't send jgroup message", (Throwable)eee);
                }
            }
            catch (ChannelClosedException eee) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't send jgroup message", (Throwable)eee);
            }
        }
    }

    public void receive(Message msg) {
        Object message = msg.getObject();
        if (log.isInfoEnabled()) {
            log.info((Object)("Receive message : " + msg.getObject()));
        }
        if (message instanceof WikittyJGroupMessage) {
            WikittyJGroupMessage wikittyMessage = (WikittyJGroupMessage)message;
            WikittyJGroupType type = wikittyMessage.type;
            WikittyServiceEvent event = wikittyMessage.event;
            event.setSource(this.ws);
            event.setRemote(true);
            switch (type) {
                case PUT_WIKITTY: {
                    this.ws.firePutWikitty(event);
                    break;
                }
                case REMOVE_WIKITTY: {
                    this.ws.fireRemoveWikitty(event);
                    break;
                }
                case CLEAR_WIKITTY: {
                    this.ws.fireClearWikitty(event);
                    break;
                }
                case PUT_EXTENSION: {
                    this.ws.firePutExtension(event);
                    break;
                }
                case REMOVE_EXTENSION: {
                    this.ws.fireRemoveExtension(event);
                    break;
                }
                case CLEAR_EXTENSION: {
                    this.ws.fireClearExtension(event);
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Not managed jgroup message " + (Object)((Object)wikittyMessage.type)));
                }
            }
        }
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.PUT_WIKITTY, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Put wikitty event skipped");
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.REMOVE_WIKITTY, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Remove wikitty event skipped");
        }
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.CLEAR_WIKITTY, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Clear wikitty event skipped");
        }
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.PUT_EXTENSION, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Put extension event skipped");
        }
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.REMOVE_EXTENSION, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Remove extension event skipped");
        }
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
        if (this.propagateCache) {
            this.sendJGroupMessage(new WikittyJGroupMessage(WikittyJGroupType.CLEAR_EXTENSION, event));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Clear extension event skipped");
        }
    }

    static class WikittyJGroupMessage
    implements Serializable {
        private static final long serialVersionUID = 1914969328584238081L;
        public WikittyJGroupType type;
        public WikittyServiceEvent event;

        private WikittyJGroupMessage(WikittyJGroupType type, WikittyServiceEvent event) {
            this.type = type;
            this.event = event;
        }

        public String toString() {
            String toString = (Object)((Object)this.type) + " " + this.event;
            return toString;
        }
    }

    static enum WikittyJGroupType {
        PUT_WIKITTY,
        REMOVE_WIKITTY,
        CLEAR_WIKITTY,
        PUT_EXTENSION,
        REMOVE_EXTENSION,
        CLEAR_EXTENSION;

    }
}

