package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminClientUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Client> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_GROUPS_VISIBLE = "clientGroups.visible";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON3_VISIBLE = "$JButton3.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL5_VISIBLE = "$JLabel5.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1aTW/byBmmlfjbjh17nWzirNd20m2CJEzibPqBbLtrO1LsVHEMSw6CBqh3JI6kSSgOMxza8hot+hP6E9p7LwV666nooeceein6F4qih16LvjMjih8iKVpMgNDSzPs+8zwPZ97hh37/L23UYdraO9Tp6My1OGlj/cXmmzevau9wnT/DTp0Rm1OmqX8jBa3wVps2eu0O126+LYv0B930B9u0bVMLW4Hsp2VtyuGnJnZaGHOufRbOqDvOg0qv+2nHdpmH2iMVh/rb//y78Bvj178raFrHBnbLIGV1UJav5GJZKxCDawsw0jF6YCKrCTQYsZrAd1a0bZvIcfZQG3/QfqWNl7UxGzEA49p6dskSQ+Z3bK7N39o02sTaphaH8MPdh1x7Uqdt/Z3LiNNGrN7Cjn7MkEF0l+hIxOp1FayrTJPIRNuWoGNcu1jDyOLaRgKMg9kxqcNXg1P9tWhSEM+qr3yMcWI9Z9QFgpeFbl14oW9RagK0HzV5jExiIFDHtbshn3sdunMC/ukVcXztNQbG4YBZQ5D/aShfZVVRzcR+8MStF2VUwyZ4tCBYdbphqlUELQEnTriJy7jBA2n7yIpJk60yzVd068WWyzm1IHgxFKyaRdiN/uhHomEtoXMjrfNxTOfsrR1iUNYjshJjTSAinHyxRo1T8XnFN24O+TOlRFlbNF8Vh7t93kol18Xhfq9vqi4zxbzn2pWQK1Xc4SWCTSOc4aFtxKDNKrRNw2BYLYTH4YCeN1/2vOlHfhyDPK2Q91uw9GJwvdQvk0mJZYjqPCX5SUzyjEqWCwbq31rM6SoTh1ewCSWUssPdyNgMf3Cxw0XM4e451v9BMC98OmegyPCX1CANgqGiXY2bQVu0001i2nIoAOqv7tdfv0COvNVGmQvNsFzf9pfsA+hSxfrTSLEWgLL3f1cW//6nf/6x5FXolzD2UmxoYIOBymkzamPGiRh6TpVnlxPzwUtkP32rTTpda6H3Rgwxz3kgB+OpiibS9R3ktABidPwff/7LlW//dkErlLQpkyKjhET8LlSTFszSFjWNjv31N5LRzMkEHOfh/wWYqw2I5qJMcW20gUwH/o5RG8GJ8Rtma5QZmO0jAufN8No74NONGJ96ZGuTf/3vYuUP33hejQD3a4nhvl+jP9fGiGUSC8v9rLtVxe5f07aDXYP6W1LcJqXBLjDxogqFegt5pftAHl/HWTIvpiexXOo6ZXRKYSVrFzkTfizAuqxSt94qdmxkGcq1bt+0QY4JmFQh38G3wqONjitG+IXULT59K2hMvajYJuGicA8mstiijHwnVrS5aZKm1ZY79c2zYAGT+xKseofDluno28W9avHgl8CqQeW2fmbhk9USfL69XsGMNNbvyW/61qvys3urGz+4A7FX/HFEOdynDuEEvmpzZ6pmeLCxksZUDHwalTvXcKrW0lSVi6Xqx9I062mSoAMURfbic6taT1N1sPt856PJuuTJUqgDdE1JXQek2UoXVvBOKghUNVx+00+wCTUeWpcM3ECuybdN6uBXUOGQorNo0COL8hYIPqLWUV1093MCg9tQU0oMFrQ9YD2MAJWjlmQ/f7YOW4nI1MFmdz1GLbgqugaBXhDLF3yEqa7kiSS9QYTgibaF29Qida6NlPzBl8KDy+B4BhOiv0TMgdJGeyyuKxZQu8FFsU02SNP1PA0S2oZzqKJ2RbXSxlQslCFxPVoldlXirSTjwZm0fVU3Y1SF4+M1Lnkat4Ox2QVfidium7SOou5HxU5yhizHRBxH9SbCeTpvxOlUQfEC5z2BZbiBcFEzy8kcx5bYGmCjfHS2hup1bPOyHOJ2E3Nl1O07Onzutt65t7reYEelg3WxxMPOdE+doqg3WMSKcfLoR9Z90Rw24np8dvikf55sBsTG+7EQ9aN0MMiRseEcwdbR862Bjrjvw3PlMNYgEZXBIPd9doPc9xkNOvxZBoO6Eq+GWDVc04S7b4yFjmPiEHm9sXC2RpxDy8B1CqsNG7eFRUEL9iMWTAVxwi4sJ4wXtmE1zgY/eIAPpV5gdh+uhXhZcMeHYpy4fJZuxF7EiHm4+T/G95Pt+Cxx2LAhX8TOiwh4vC2feLbsBdCz18vLIYa4Q3hY8puI5IsqJCxzqQ8kLO96nDwRFi9pxpNUhJAhd1wwIyzkZcqOC8FpOy50Z2exEGChDHHCRDZ9IlcjRFR8PJVpEbGpALOzmQ+yEbfKiVyyX4ZMSiYCLDuPywEe6tlA3448jClzPSrqUc5wxjTVc70gn+fD8bnU4yMffWSnsxiZu9VTO/mK8TyMZnuMzjeNPwkQ6rTNCmcYtftKwzCMFnqM3ni4w80juOvhbmRxVfLOo4oEHc4n3sIOclmUUzWvT1UPd7jpjWE8M0ypOPS6Lwqw7DyuRnl8zNV/uUdo6/S863+pj1j/ljHkkpsL0Drfogu6Rdo2ZbzYEccwrd1hTp687dgNYGZntZLACnbwfnLF4Tybkp59LGLqS6Jr5yamfMtO7PMkYgwTuLzshJkd5LggOFCAw10kqTGDVHDy1BKtKRdJO9gcuN0lXXXG8ghfdaqQtKtOEZF+1SkjkmXMeDLySHEIj+zbTlSKCkmTIiIySBFhA6RUICS7lIUQC1STT6ojl4shLaPdmNhnJkGYsJrlODUyLuUaRsjZFDEZbvomG7TuOuF3ECHiE/L5YRXVotzD94kfXMJ3evNqjlHTpMeYFb1nD+mvM3zBK75g8S5SCfYoJCwqr3uQ3ALXxszuW4Vl+cR3i3bUa4bb3VfJ91YfijtZj82iz6YbEE/BexOd4UGq/zjm0lcG4mi1BmWJWM2f9uGOiONUBkg5J6G3sBaPcS0LBqnLl8FJGKsDMUTyF7AyvlKvj1YR54zUXI4TlA1G9J835Ca2moJwM5s0cXiYB+FJbg53UxC+l9uHwQjhEpBiSDYyaYZkQ0gz5Pu5DcmGsJfiQzaENB8GI8AqaREDw0lJgbmTBcZp0ZP8MGMcsSZOq0dZUGYVyuuB6z8L2DTcGZK22xbvh1Og9NyF4GF2hAQOG7k5PMnN4Ye5196Pc6t4mlvFT3Jz+Do3h83cHLZzV5DBCLDakGFU6TZt12h6AShmAJuRYOKHRXmxRPJZTjYTDMNtH8MsJ86kqI7yh3MpZyubpLSzlYWK/I1mCsZOBoy430ykCBPv0f4PATRzt98rAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminClientForm;
    protected com.jurismarches.vradi.services.dto.VradiClientDTO bean;
    protected javax.swing.JTextField clientAddress;
    protected javax.swing.JTextField clientContact;
    protected jaxx.runtime.swing.ListSelectorUI< Group > clientGroups;
    protected javax.swing.JTextField clientName;
    protected javax.swing.JTextField clientPhone;
    protected java.lang.Boolean inGroup;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        clientGroups.addPropertyChangeListener(ListSelectorUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Group> toCombo = getHandler().getAllGroups(this);
        java.util.List<Group> toList  = new java.util.ArrayList<Group>(toCombo);
    
        for (java.util.Iterator<Group> it = toList.iterator(); it.hasNext();) {
            Group group = it.next();
            if (group.getClient() == null || !group.getClient().contains(bean.getWikittyId())) {
                it.remove();
                log.debug("client does NOT use group " + group.getName());
            } else {
                toCombo.remove(group);
                log.debug("client use group " + group.getName());
            }
        }
        clientGroups.init(toCombo, toList);
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        setInGroup(parentNode != null);
    
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
    }
    
    @Override
    protected void updateBeanFromEntity(Client bean) {
        this.bean.fromWikitty(bean);
        log.debug(this.bean.getLastModified() + " " + this.bean.getLastModifier());
    }
    
    @Override
    public void save() {
    
        // objects to save
        java.util.Collection<Object> toSave = new java.util.ArrayList<Object>();
    
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        Client bean = (Client) getHelper().getSelectedBean(this);
        if(!bean.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            bean.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        this.bean.toWikitty(bean);
        log.info("===================================================================================");
        log.info("client to save " + bean.getName());
        toSave.add(bean);
    
        String wikittyId = bean.getWikittyId();
        for (Group g : clientGroups.getComboDatas()) {
            log.debug("test group without this client " + g.getName() + " - " + g.getClient());
            if (g.getClient() != null && g.getClient().contains(wikittyId)) {
                // group was containing client, but no more
                g.removeClient(wikittyId);
                // mark it for save
                toSave.add(g);
                log.info("group to save (client was removed) " + g);
            }
        }
        for (Group g : clientGroups.getListDatas()) {
            log.debug("test group with this client " + g.getName() + " - " + g.getClient());
            if (g.getClient() == null || !g.getClient().contains(wikittyId)) {
                // group was not containing client, but do now
                g.addClient(wikittyId);
                // mark it for save
                toSave.add(g);
                log.info("group to save (client was added) " + g);
            }
        }
        getHandler().save(this, getHelper(), toSave.toArray(new Object[toSave.size()]));
        clientGroups.setModified(false);
        log.info("===================================================================================");
    }
    
    protected void deleteFromGroup() {
        log.info("===================================================================================");
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        Group group = (Group) parentNode.getBean(this);
        log.info("group to save " + group.getName());
        group.removeClient(bean.getWikittyId());
        getHandler().save(group);
        getHelper().reloadGroup(this, parentNode, group);
        getHelper().selectNode(this, parentNode.getFullPath());
        log.info("===================================================================================");
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI() {
        super();
        $initialize();
    }

    public AdminClientUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createClient(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper());
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        deleteFromGroup();
    }

    public void doKeyReleased__on__clientAddress(java.awt.event.KeyEvent event) {
        bean.setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(java.awt.event.KeyEvent event) {
        bean.setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(java.awt.event.KeyEvent event) {
        bean.setName(clientName.getText());
    }

    public void doKeyReleased__on__clientPhone(java.awt.event.KeyEvent event) {
        bean.setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminClientForm() {
        return adminClientForm;
    }

    public com.jurismarches.vradi.services.dto.VradiClientDTO getBean() {
        return bean;
    }

    public javax.swing.JTextField getClientAddress() {
        return clientAddress;
    }

    public javax.swing.JTextField getClientContact() {
        return clientContact;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getClientGroups() {
        return clientGroups;
    }

    public javax.swing.JTextField getClientName() {
        return clientName;
    }

    public javax.swing.JTextField getClientPhone() {
        return clientPhone;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientGroups, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", clientName);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new jaxx.runtime.swing.Table());
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiClientDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new javax.swing.JTextField());
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new javax.swing.JTextField());
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientGroups() {
        $objectMap.put("clientGroups", clientGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        clientGroups.setName("clientGroups");
        clientGroups.setShowHidor(true);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new javax.swing.JTextField());
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new javax.swing.JTextField());
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO >(com.jurismarches.vradi.services.dto.VradiClientDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($JButton2);
        $JPanel0.add($JButton3);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        $JButton3.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        $HidorButton0.setHideTip(_("vradi.adminClient.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminClient.showForm"));
        $HidorButton0.setTarget(adminClientForm);
        $HidorButton0.setTargetVisible(true);
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton4.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        clientGroups.setAddToComboTip(_("vradi.adminClient.removeGroups"));
        clientGroups.setAddToListTip(_("vradi.adminClient.addGroup"));
        clientGroups.setMinimumSize(new Dimension(100,250));
        clientGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setFont(new Font("Serif", Font.BOLD, 26));
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 17 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createClient"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminClient.createUser"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(_("vradi.adminClient.deleteClientFromGroup"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminClientForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminClient.listGroup"));
        createClientGroups();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setVisible(isInGroup());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientAddress, bean.getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_PHONE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("phone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientPhone, bean.getPhone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("phone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_CONTACT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientContact, bean.getContact());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                clientGroups.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}