package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DELETABLE = "deletable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_SELECTED_MODEL = "thesaurusSelected.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1ZTXPbuBmmFX/JH7Etx84mzoftuDvONKE3e9iPyU67tleK7SqJR1I6mfrgQiQkIaEIBgRtOZ7d6U/oT2jvvXSmt546PfTcQy+d/oVOp4deeuj0BSiKHyIlmnJmIkvAiwfP8wAvABK/+6cyYTNl4x3qdFTmmJy0sXq0+/bt6/o7rPHvsK0xYnHKFPffWE7JnSizeq/c5sqjk7JovtNtvrNP2xY1sRlo/byszNj8wsB2C2POlfvhFppt71R71c87lsM81B6pONTf/PtfuV/rv/ptTlE6FrCbASnrw1r5SsbLSo7oXClAT2dox0BmE2gwYjaB77wo2zeQbb9CbfxB+UGZKiuTFmIAxpXN9JIlhmzfsbgyy1vYRg5z7DeHXPmRRtvqO4cRu42YBjXqGUM6UR2i1vw4y5LtJ7kyXsfI5MpWQjMgQDiBnyXK2n6rvI4NzFEdPpQlIUsVUtU9Sg2A8+OWt6qS/KEJKMggHzH7jCufSkOhR4sYmKmuPrUv0oeZ3joqozo2oG1B9NZR7XPwVHVLRVDep7Z1tOdwTk0IXg4Fu8Xh6PmtI+iXGsYxMjG0uB1q4VeFWy31LK+CDxrHetcGnxixuQhei+/pmSi8HyHeA42C1RiWBDYsmI1rodkI81z157k/EcdOlAnmQDFXPjnpT40KVLlJ8UkkKQSgrP3f6vLf/viPP5S8TPgK+l6JDQ0kMsxQi1ELMzFnuLLgpoHDibHzElnPT5S8LQ2TWX4vhli1Ww3koD93aonm6gGyWwAxMfX3P/159Zd/vaHkSsqMQZFeQiL+UNjHwAVq6B3rp99KRnPn0/C5CP9vgL0NiO5O2YkGMmz4O0kt9MEJFMzXKdMxO0bElIPqlnfAp3sxPvXI1vN/+c9y9fffel6NAfc7ieG+XxO/UCaJaRATy3WjuyTErhOzlo0dnfqpH7cYKLAcTB/VIAv3kJc+P5afO3GWLGoU2JkOdewyuqCQHso4Z8KPAiw9NeporWLHQqbuutatm9XJGQGTqpCjXMk9+7zjiB6+lLrFt68FjZmjqmUQLib7cCLLLcrIRyCDjF2DNM22XBEfXQazoCo+96lpc1ivbHW/+KpWrHwPrBpULp+XJj5fL8H37c0qZqSx+UT+Uvdel797sv75F48hdtXvp4Y7/JjasNjAT2Xh0l1KPNhYSZNuDHybgEURciuTqo1BqsrFUu26NM17miToEEV5qaiMGzybqs1BqiqHLw6uTdZNT5aLOkTXjNRVIc3WYGE5b1BBoLvzyV/qOTZgn4LSFR03kGPwfYPa+DWscMils6zTU5PyFgg+peapJqr7OYHBbVhTSgwS2hqSD2NA5bQl2S9ebsK+LVqqYLOzGaMWXBVVw0BviPQFH2Gqu/JEI7VBhODptonb1CQaV8ZKfucr4c5lcDyDaVFfguphLCZ6LO66LGDtBhfhKGA2SNPxPA0S2ocxdKMOxWqlTLqx4tgDy1yNWDWJ9yAZD0bS8lU9ilEVjo/XuOJp3A/Gphe8GrFdNaiGou5HxeY5Q6ZtII6jehPhPJ334nS6QfECFz2BZTjJOaiZZjCnsCm2Btgon11uIE3DFi/LLrabmLtGbT9W4Xu39PGT9c0GOy1VNkWKh53pDp1LUW2wiBVT5NlX5lNRHDbibnzr8KA/TDYDYuP9KET9KFWGOTKZzRFsnr7YG+qI8z48V97EGiSiUhjkvE9vkPM+pUFvfpbCoK7E2yFWDccw4CkAY6HjjNhEnjcKlxvEfmPqWKOQbVjfFhYFLTiOWDATxAm7sJbQX9iG9Tgb/OAhPpR6gel9uBPiZcJDFopxYulysBGvIkYswlPYGX6abMf9xG7DhnwaOy8i4PG23PJseRVAT79eLoUY4g7hYclvI5LH3ZCwzJU+kLC8u3HyRFi8pDlPUhFCMu64YEZYyMsBOy4ED9px5SN5WhaFAAvXEDtMZNcncjtCxI2PpzIrInZdwPRsFoNs9DYxE7mkP4bkJRMBlp7HUoCHZhB5lo3syFlMWehR2Zeg2YxpMupYYT4vsvG52ePzQmCmp7Mcmbu1Cyv5xHgVRvM9RlebxrcChDpto8oZRu2+pSELo0KP0VsPN9s8gqce7kSSqzrqPKpK0Gw+BV4sBTnVRvWp90Ix2/TG0J8RplTMnPdFAZaex+0oj+vM/qUeob2Lq+b/Sh+x/i0jY8otBGhdLemCbpG2RRkvdsRnmNZhlsGTjx2HAcz0rB4ksIIdvJ9cMZtnM9Kz6yLm/kh07crEXN/SE3uYRIxhAsfLTphZZYQDQcUFzHZIcvsMUsHJU0uUDjgkHWBj6HaXdOqM5RE+dbohg06dImLwqVNGJMuY82SMIsUmPLJv21EpbsggKSIihRQRNkRKFULSSymEWKC6fFMdOS6GtEx0Y2LfmQRhwmrW4tTIuAFnGCFnV8SkeOjLN6jm2OE7iBDxafn+sIbqUe7h58QPDuEHvXm1IG6V6BlmRe/dw+DrDF/wA19wneoXrmCPQkJSedXD5Oa4Mml0bxXW5BvfPdpxrxm2hbQ6Yk/WPxNPsh6bZZ9NNyCewlS3NsWL1O4EuvmNjjhar8OaRMzmT/pAx8Tnagq84KBA0Nh/s0ONE01eRiZh3EmBER3fwjfubdI64pyRusNxgtY04HNysnaxISo3kx0r4W3+iKjd67sRUWDh+4hHHIilM3HlqQWuREYkdcsDvEa7vPdJI2qd07BhVDBs7wyzAVgP01x0tKkuL/BHAbmF5SVl7y7+GPGWPcCrrRSYeXFV9bQ7M7IDicZfDpCXhsoso5T/vDd0o6i66d6+w1R6OcT3NGiLdoue2xVgdwD2u/ehg9j9H0WFCQ4aJAAA";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected java.lang.Boolean deletable;
    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeHelper helper;
    DefaultListModel thesaurusSelectedModel;
    
    
    public  ThesaurusUI(jaxx.runtime.JAXXContext parentContext, VradiThesaurusDTO rootThesaurus) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = new ThesaurusTreeHelper(this, rootThesaurus);
        setContextValue(helper);
    $initialize();
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SimpleJAXXObjectBinding sjob = new SimpleJAXXObjectBinding(this, PROPERTY_BEAN, false, "bean"){
            @Override
            public void processDataBinding() {
                if (log.isDebugEnabled()){
                    log.debug("tryToSelect");
                }
                helper.tryToSelect(ThesaurusUI.this, getBean().getThesaurus());
            }
        };
        registerDataBinding(sjob);
        sjob.applyDataBinding();
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddCriteria = new JMenuItem();
                    menuAddCriteria.setText(_("vradi.menu.addCriteria"));
                    menuAddCriteria.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addCriteriaSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddCriteria);
    
                    JMenuItem menuAddColumns = new JMenuItem();
                    menuAddColumns.setText(_("vradi.menu.addColumns"));
                    menuAddColumns.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addColumnSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesorusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
    
                    }
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
                if (!isSelected){
                    thesaurus.getSelectionModel().clearSelection();
                }
            }
        });
    
        thesaurus.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        });
    
        SwingUtil.addExpandOnClickListener(thesaurus);
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.JAXXUtil.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                NavigationTreeNode selected = (NavigationTreeNode)path.getLastPathComponent();
                VradiThesaurusDTO thesaurusSelected = (VradiThesaurusDTO)selected.getBean(this);
                thesaurusSelectedModel.addElement(thesaurusSelected.getBean());
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent e){
        // Recuperation de la source
        JTree tree = (JTree) e.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesorusSelected(TreePath path){
        log.debug("addThesorusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addThesaurusUI(this, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
        getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = helper.getRootNamePath();
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public java.lang.Boolean getDeletable() {
        return deletable;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    public java.lang.Boolean isDeletable() {
        return deletable !=null && deletable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setDeletable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.deletable;
        this.deletable = newValue;
        firePropertyChange(PROPERTY_DELETABLE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDeletable() {
        $objectMap.put("deletable", deletable = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusUI", this);
        createBean();
        createDeletable();
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(helper.getRootNamePath()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(isDeletable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_SELECTED_MODEL, true ,"thesaurusSelectedModel") {
        
            @Override
            public void processDataBinding() {
                thesaurusSelected.setModel(thesaurusSelectedModel);
            }
        });
    }

}