/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.web.job.ClientUpdateJob;
import com.franciaflex.faxtomail.web.job.EDIManagementJob;
import com.franciaflex.faxtomail.web.job.MailFilterJob;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class FaxToMailApplicationListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(FaxToMailApplicationListener.class);
    protected FaxToMailApplicationContext applicationContext;
    protected Scheduler scheduler;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)"init FaxToMail web ui");
        }
        log.debug((Object)"scheduler launched");
        ServletContext sc = sce.getServletContext();
        this.applicationContext = new FaxToMailApplicationContext();
        this.applicationContext.init(sc);
        sce.getServletContext().setAttribute("faxToMailApplicationContext", (Object)this.applicationContext);
        FaxToMailConfiguration config = this.applicationContext.getApplicationConfig();
        JobDataMap data = new JobDataMap();
        data.put("applicationContext", (Object)this.applicationContext);
        JobDetail mailFilteringJob = JobBuilder.newJob(MailFilterJob.class).usingJobData(data).withIdentity("faxToMailJobs", "mailFilteringJob").build();
        JobDetail ediManagementJob = JobBuilder.newJob(EDIManagementJob.class).usingJobData(data).withIdentity("faxToMailJobs", "ediManagementJob").build();
        JobDetail clientUpdateJob = JobBuilder.newJob(ClientUpdateJob.class).usingJobData(data).withIdentity("faxToMailJobs", "clientUpdateJob").build();
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("mailFiltering", "mailFilteringTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)config.getJobMailExpression())).build();
            this.scheduler.scheduleJob(mailFilteringJob, trigger);
            trigger = TriggerBuilder.newTrigger().withIdentity("ediManagement", "ediManagementTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)config.getJobEdiExpression())).build();
            this.scheduler.scheduleJob(ediManagementJob, trigger);
            trigger = TriggerBuilder.newTrigger().withIdentity("clientUpdates", "clientUpdatesTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)config.getJobCientExpression())).build();
            this.scheduler.scheduleJob(clientUpdateJob, trigger);
            this.scheduler.start();
            log.debug((Object)"schedulers launched");
        }
        catch (SchedulerException e) {
            log.error((Object)"Error while launching the mail filter job", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        block5: {
            if (this.scheduler != null) {
                if (log.isInfoEnabled() && log.isInfoEnabled()) {
                    log.info((Object)"Stopping quartz sheduler");
                }
                try {
                    this.scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn((Object)"Can't stop quartz", (Throwable)e);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing web ui application context");
        }
        this.applicationContext.close();
    }
}

