/*
 * #%L
 * FaxToMail :: Web
 * $Id: configuration.js 186 2014-06-11 11:02:07Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/webapp/js/configuration.js $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

var ConfigurationModule = angular.module('ConfigurationModule', ['FaxToMail', 'ui.tree', 'ui.sortable', 'ui.select2.sortable']);

/**
 * Global configuration controller.
 */
ConfigurationModule.controller('ConfigurationController', ['$scope', 'ConfigurationData',
  function($scope, ConfigurationData) {
    //{Object} L'object configuration
    $scope.configuration = ConfigurationData.configuration;
    //{Map} les actions possibles pour les etats d'attentes
    $scope.mailActions = ConfigurationData.mailActions;
    //{Map} les champs obligatoires possibles
    $scope.canBeRequiredMailFields = ConfigurationData.canBeRequiredMailFields;
    //{Map} les champs possibles du tableau
    $scope.tableMailFields = ConfigurationData.tableMailFields;
    //{Array} les etats d'attentes disponibles
    $scope.etatAttentes = ConfigurationData.etatAttentes;
    //{Array} les types de documents
    $scope.demandTypes = ConfigurationData.demandTypes;
    //{Array} mail folders
    $scope.mailFolders = ConfigurationData.mailFolders;
    // {Map} Mail folder usage
    $scope.mailFoldersUsage = ConfigurationData.mailFoldersUsage;
    //{Map<MailFolder id, Array<MailFolder>>} liste des 
    $scope.flatMailFolders;
    //{Array} All application users
    $scope.users = ConfigurationData.users;
    // {Array} All application groups
    $scope.groups = ConfigurationData.groups;

    // method privée recursive pour retourner l'ensemble des dossiers en les modifiant pour ajouter
    // des metadata (full path from root, and root node instance)
    var recursiveAddMailFolder = function(result, mailFolders, rootFolder, prefix, parent) {
      var cumulativeCount = 0;
      if (mailFolders) {
        angular.forEach(mailFolders, function(mailFolder) {

          // warning modify input object :(
          // use $ from this, even not recommended because angular exlude those fields when jsonify
          mailFolder.$fullPath = prefix + "/" + mailFolder.name;
          // ha la la, modify input object again :(
          // use $ from this, even not recommended because angular exlude those fields when jsonify
          mailFolder.$rootFolder = rootFolder;
          // encore pour le parent
          mailFolder.$parent = parent;

          var folderCount = 0;
          if ($scope.mailFoldersUsage.hasOwnProperty(mailFolder.topiaId)) {
            folderCount += $scope.mailFoldersUsage[mailFolder.topiaId];
          }

          result.push(mailFolder);
          folderCount += recursiveAddMailFolder(result, mailFolder.children, rootFolder, mailFolder.$fullPath, mailFolder);
          
          // et on modifie encore (tant qu'on a commencé !!!)
          mailFolder.$cumulativeCount = folderCount;
          cumulativeCount += folderCount;
        });
      }
      return cumulativeCount;
    };

    // update $scope.flatMailFolders when $scope.mailFolders changes
    $scope._updateFlatMailFolders = function() {
      console.log("Update flatMailFolders map");
      $scope.flatMailFolders = {};
      angular.forEach($scope.mailFolders, function(mailFolder) {
        $scope.flatMailFolders[mailFolder.topiaId] = [];
        var cumulativeCount = recursiveAddMailFolder($scope.flatMailFolders[mailFolder.topiaId], mailFolder.children, mailFolder, mailFolder.name, mailFolder);
        mailFolder.$cumulativeCount = cumulativeCount;
      });
    };
    $scope._updateFlatMailFolders();
}]);

/**
 * Misc tab controller.
 */
ConfigurationModule.controller('ConfigurationMiscController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {

    // selection/deselection d'une action
    $scope.changeInvalidAction = function(action) {
      var index = $scope.configuration.invalidFormDisabledActions.indexOf(action);
      if (index != -1) {
        $scope.configuration.invalidFormDisabledActions.splice(index, 1);
      } else {
        $scope.configuration.invalidFormDisabledActions.push(action);
      }
    };

    // Ajout d'une nouvelle ligne vide d'extension
    $scope.addExtensionRow = function() {
      if (!$scope.configuration.extensionCommands) {
        $scope.configuration.extensionCommands = [];
      }
      $scope.configuration.extensionCommands.push({});
    };
    
    // suppression d'un ligne
    $scope.deleteExtensionRow = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer cette extension ?")) {
        $scope.configuration.extensionCommands.splice(index, 1);
      }
    };
}]);

/**
 * Etat attente tab controller.
 */
ConfigurationModule.controller('ConfigurationEtatAttenteController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    //{Map} Usage des états d'attente
    $scope.etatAttentesUsage = ConfigurationData.etatAttentesUsage;
    //{Object} etat d'attente selectionné
    $scope.selectedEtatAttente;

    // edition de l'etat d'attent cliqué
    $scope.editEtatAttente = function(etatAttente) {
      $scope.selectedEtatAttente = etatAttente;

      // initialize le tableau d'action si vide
      if (!$scope.selectedEtatAttente.invalidFormDisabledActions) {
        $scope.selectedEtatAttente.invalidFormDisabledActions = [];
      }
      if (!$scope.selectedEtatAttente.validFormDisabledActions) {
        $scope.selectedEtatAttente.validFormDisabledActions = [];
      }
    };

    // ajout d'un nouvel etat d'attente
    $scope.newEtatAttente = function() {
      var label = $window.prompt("Nom du nouvel état d'attente ?");
      if (label) {
        // auto select new etat
        var newEtatAttente = {
            topiaId : "new_" + guid(),
            label: label
        };
        $scope.etatAttentes.push(newEtatAttente);
        
        // auto select
        $scope.editEtatAttente(newEtatAttente);
      }
    };

    // suppression d'un etat d'attente non utilisé
    $scope.deleteEtatAttente = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer cet état d'attente ?")) {
        $scope.etatAttentes.splice(index, 1);
      }
    };

    // selection/deselection d'une action
    $scope.changeEtatAttenteValidAction = function(action) {
      var index = $scope.selectedEtatAttente.validFormDisabledActions.indexOf(action);
      if (index != -1) {
        $scope.selectedEtatAttente.validFormDisabledActions.splice(index, 1);
      } else {
        $scope.selectedEtatAttente.validFormDisabledActions.push(action);
      }
    };
    
    // selection/deselection d'une action
    $scope.changeEtatAttenteInvalidAction = function(action) {
      var index = $scope.selectedEtatAttente.invalidFormDisabledActions.indexOf(action);
      if (index != -1) {
        $scope.selectedEtatAttente.invalidFormDisabledActions.splice(index, 1);
      } else {
        $scope.selectedEtatAttente.invalidFormDisabledActions.push(action);
      }
    };
}]);


/**
 * Demand type tab controller.
 */
ConfigurationModule.controller('ConfigurationDemandTypeController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    //{Object} demand type selectionné
    $scope.selectedDemandType;

    // edition d'un type de demande
    $scope.editDemandType = function(demandType) {
      $scope.selectedDemandType = demandType;

      // initialize le tableau d'action si vide
      if (!$scope.selectedDemandType.fields) {
        $scope.selectedDemandType.fields = [];
      }
    };

    // ajout d'un nouvel etat d'attente
    $scope.newDemandType = function() {
      var label = $window.prompt("Nom du nouveau type de document ?");
      if (label) {
        // auto select new etat
        var newDemandType = {
            topiaId : "new_" + guid(),
            label: label
        };
        $scope.demandTypes.push(newDemandType);
        
        // auto select
        $scope.editDemandType(newDemandType);
      }
    };

    // selection/deselection d'un champ
    $scope.changeDemandTypeField = function(mailField) {
      
      var index = $scope.selectedDemandType.fields.indexOf(mailField);
      if (index != -1) {
        $scope.selectedDemandType.fields.splice(index, 1);
      } else {
        $scope.selectedDemandType.fields.push(mailField);
      }
    };
}]);


/**
 * Mail folder tab controller.
 */
ConfigurationModule.controller('ConfigurationTreeController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    // {Object} selected mail folder
    $scope.selectedMailFolder;
    // {String} add new customer responsible form value
    $scope.newCustomerResponsible;
    // {String} add new customer responsible form value
    $scope.newReplyAddress;
    // {String} add new domain form value
    $scope.newReplyDomain;
    // {Array} Colonnes selectionnées pour le dossier courant
    $scope.folderTableColumns;
    // {Array} Colonnes selectionnées pour les dossiers parents
    $scope.parentFolderTableColumns;
    // {Object} Global parent wide configuration and values
    $scope.parentScopeValues;

    // creation d'un nouveau noeud racine
    $scope.newRoot = function() {
      var name = $window.prompt("Nom du nouveau dossier racine ?");
      if (name) {
        var newRoot = {
          topiaId: "new_" + guid(),
          name: name,
          children: []
        };
        $scope.mailFolders.push(newRoot);
        $scope._updateFlatMailFolders(); // update flat map
        
        // edition automatique
        $scope.editMailFolder(newRoot);
      };
    };

    // new sub folder
    $scope.newSubFolder = function(scope) {
      var nodeData = scope.$modelValue;
      var name = $window.prompt("Nom du nouveau noeud ? ");
      if (name) {
        var newNode = {
            topiaId: "new_" + guid(),
            name: name,
            children: [],
            useCurrentLevelEtatAttente: false,
            useCurrentLevelTableColumns: false,
            useCurrentLevelFaxDomain: false,
            useCurrentLevelEdiFolder: false
          };
        // extend node (in faxtomail collapsed = extended)
        scope.collapse();
        // append new node
        nodeData.children.push(newNode);
        // edition automatique
        $scope.editMailFolder(newNode);
        // update flat map
        $scope._updateFlatMailFolders(); 
      }
    };

    // suppression d'un dossier
    $scope.deleteFolder = function(scope) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce dossier ?")) {
        scope.remove(scope);
      }
    };

    // edit mail folder
    $scope.editMailFolder = function(mailFolder) {
      $scope.selectedMailFolder = mailFolder;
      
      // edit undefined collections
      if (!$scope.selectedMailFolder.customerResponsibles) {
        $scope.selectedMailFolder.customerResponsibles = [];
      }
      if (!$scope.selectedMailFolder.replyAddresses) {
        $scope.selectedMailFolder.replyAddresses = [];
      }
      if (!$scope.selectedMailFolder.replyDomains) {
        $scope.selectedMailFolder.replyDomains = [];
      }
      if (!$scope.selectedMailFolder.folderTableColumns) {
        $scope.selectedMailFolder.folderTableColumns = [];
      }
      if (!$scope.selectedMailFolder.etatAttentes) {
        $scope.selectedMailFolder.etatAttentes = [];
      }
      if (!$scope.selectedMailFolder.readRightUsers) {
        $scope.selectedMailFolder.readRightUsers = [];
      }
      if (!$scope.selectedMailFolder.writeRightUsers) {
        $scope.selectedMailFolder.writeRightUsers = [];
      }
      if (!$scope.selectedMailFolder.moveRightUsers) {
        $scope.selectedMailFolder.moveRightUsers = [];
      }
      if (!$scope.selectedMailFolder.readRightGroups) {
        $scope.selectedMailFolder.readRightGroups = [];
      }
      if (!$scope.selectedMailFolder.writeRightGroups) {
        $scope.selectedMailFolder.writeRightGroups = [];
      }
      if (!$scope.selectedMailFolder.moveRightGroups) {
        $scope.selectedMailFolder.moveRightGroups = [];
      }
      

      // initialise la liste des colonnes pour le dossier courant
      $scope.folderTableColumns = [];
      angular.forEach($scope.selectedMailFolder.folderTableColumns, function(folderTableColumn) {
        $scope.folderTableColumns.push({
          id: folderTableColumn,
          label: $scope.tableMailFields[folderTableColumn]
        });
      });
      
      // change instance (for indexOf() to work)
      if ($scope.selectedMailFolder.etatAttentes) {
        var newArray = [];
        angular.forEach($scope.selectedMailFolder.etatAttentes, function(folderEtatAttente) {
          angular.forEach($scope.etatAttentes, function(etatAttente) {
            if (etatAttente.topiaId == folderEtatAttente.topiaId) {
              newArray.push(etatAttente);
            }
          });
        });
        $scope.selectedMailFolder.etatAttentes = newArray;
      }
      
      // right
      $scope.selectedMailFolder.rightUsers = [];
      $scope.selectedMailFolder.rightGroups = [];
      angular.forEach($scope.selectedMailFolder.readRightUsers, function(user) {
        if ($scope.selectedMailFolder.rightUsers.indexOf(user) == -1) {
          $scope.selectedMailFolder.rightUsers.push(user);
        }
      });
      angular.forEach($scope.selectedMailFolder.writeRightUsers, function(user) {
        if ($scope.selectedMailFolder.rightUsers.indexOf(user) == -1) {
          $scope.selectedMailFolder.rightUsers.push(user);
        }
      });
      angular.forEach($scope.selectedMailFolder.moveRightUsers, function(user) {
        if ($scope.selectedMailFolder.rightUsers.indexOf(user) == -1) {
          $scope.selectedMailFolder.rightUsers.push(user);
        }
      });
      angular.forEach($scope.selectedMailFolder.readRightGroups, function(group) {
        if ($scope.selectedMailFolder.rightGroups.indexOf(group) == -1) {
          $scope.selectedMailFolder.rightGroups.push(group);
        }
      });
      angular.forEach($scope.selectedMailFolder.writeRightGroups, function(group) {
        if ($scope.selectedMailFolder.rightGroups.indexOf(group) == -1) {
          $scope.selectedMailFolder.rightGroups.push(group);
        }
      });
      angular.forEach($scope.selectedMailFolder.moveRightGroups, function(group) {
        if ($scope.selectedMailFolder.rightGroups.indexOf(group) == -1) {
          $scope.selectedMailFolder.rightGroups.push(group);
        }
      });
    };

    // on doit faire ca par l'ordre des watch angular et ne pas l'appeler dans le edit
    // sinon, les champs $ ne sont pas valués
    $scope.$watch("selectedMailFolder", function(newValue, oldValue) {
      if (newValue) {
        // initialise default values pour le noeud racines
        if (!$scope.selectedMailFolder.$parent) {
          $scope.selectedMailFolder.allowCreateDemandIntoFolder = $scope.selectedMailFolder.allowCreateDemandIntoFolder || false;
          $scope.selectedMailFolder.allowMoveDemandIntoFolder = $scope.selectedMailFolder.allowMoveDemandIntoFolder || false;
          $scope.selectedMailFolder.openAttachmentReportNoTaken = $scope.selectedMailFolder.openAttachmentReportNoTaken || false;
          $scope.selectedMailFolder.printActionEqualTakeAction = $scope.selectedMailFolder.printActionEqualTakeAction || false;
          $scope.selectedMailFolder.rejectUnknownSender = $scope.selectedMailFolder.rejectUnknownSender || false;
        }
        
        // initialisation des valeurs du parent
        $scope.parentScopeValues = {
          customerResponsibles: [],
          replyAddresses: [],
          replyDomains: [],
          folderTableColumns: [],
          etatAttentes: [],
          //rigths
          readRightUsers: [],
          readRightGroups: [],
          writeRightUsers: [],
          writeRightGroups: [],
          moveRightUsers: [],
          moveRightGroups: []
        };
        updateParentScopeValues($scope.selectedMailFolder.$parent);
        
        // init select 2 data for parent
        if ($scope.parentScopeValues.folderTableColumns) {
          $scope.parentFolderTableColumns = [];
          angular.forEach($scope.parentScopeValues.folderTableColumns, function(folderTableColumn) {
            $scope.parentFolderTableColumns.push({
              id: folderTableColumn,
              label: $scope.tableMailFields[folderTableColumn]
            });
          });
        }

        // parent rigths
        $scope.parentScopeValues.rightUsers = [];
        $scope.parentScopeValues.rightGroups = [];
        angular.forEach($scope.parentScopeValues.readRightUsers, function(user) {
          if ($scope.parentScopeValues.rightUsers.indexOf(user) == -1) {
            $scope.parentScopeValues.rightUsers.push(user);
          }
        });
        angular.forEach($scope.parentScopeValues.writeRightUsers, function(user) {
          if ($scope.parentScopeValues.rightUsers.indexOf(user) == -1) {
            $scope.parentScopeValues.rightUsers.push(user);
          }
        });
        angular.forEach($scope.parentScopeValues.moveRightUsers, function(user) {
          if ($scope.parentScopeValues.rightUsers.indexOf(user) == -1) {
            $scope.parentScopeValues.rightUsers.push(user);
          }
        });
        angular.forEach($scope.parentScopeValues.readRightGroups, function(group) {
          if ($scope.parentScopeValues.rightGroups.indexOf(group) == -1) {
            $scope.parentScopeValues.rightGroups.push(group);
          }
        });
        angular.forEach($scope.parentScopeValues.writeRightGroups, function(group) {
          if ($scope.parentScopeValues.rightGroups.indexOf(group) == -1) {
            $scope.parentScopeValues.rightGroups.push(group);
          }
        });
        angular.forEach($scope.parentScopeValues.moveRightGroups, function(group) {
          if ($scope.parentScopeValues.rightGroups.indexOf(group) == -1) {
            $scope.parentScopeValues.rightGroups.push(group);
          }
        });
      }
    });

    var updateParentScopeValues = function(folder) {
      if (folder) {
        // take current folder first before parent values (warn about 'undefined' and 'false')
        if (angular.isUndefined($scope.parentScopeValues.allowCreateDemandIntoFolder)) {
          $scope.parentScopeValues.allowCreateDemandIntoFolder = folder.allowCreateDemandIntoFolder;
        }
        if (angular.isUndefined($scope.parentScopeValues.allowMoveDemandIntoFolder)) {
          $scope.parentScopeValues.allowMoveDemandIntoFolder = folder.allowMoveDemandIntoFolder;
        }
        if (angular.isUndefined($scope.parentScopeValues.openAttachmentReportNoTaken)) {
          $scope.parentScopeValues.openAttachmentReportNoTaken = folder.openAttachmentReportNoTaken;
        }
        if (angular.isUndefined($scope.parentScopeValues.printActionEqualTakeAction)) {
          $scope.parentScopeValues.printActionEqualTakeAction = folder.printActionEqualTakeAction;
        }
        if (angular.isUndefined($scope.parentScopeValues.rejectUnknownSender)) {
          $scope.parentScopeValues.rejectUnknownSender = folder.rejectUnknownSender;
        }
        if (!$scope.parentScopeValues.faxDomain) {
          $scope.parentScopeValues.faxDomain = folder.faxDomain;
        }
        if (!$scope.parentScopeValues.ediFolder) {
          $scope.parentScopeValues.ediFolder = folder.ediFolder;
        }
        if ((!$scope.parentScopeValues.folderTableColumns || $scope.parentScopeValues.folderTableColumns.length == 0) && folder.folderTableColumns) {
          $scope.parentScopeValues.folderTableColumns = folder.folderTableColumns;
        }
        if ((!$scope.parentScopeValues.etatAttentes || $scope.parentScopeValues.etatAttentes.length == 0) && folder.etatAttentes) {
          $scope.parentScopeValues.etatAttentes = folder.etatAttentes;
        }

        // move to parent first to keed parent order for collection
        if (folder.$parent) {
          updateParentScopeValues(folder.$parent);
        };

        // parents values
        if (folder.customerResponsibles) {
          $scope.parentScopeValues.customerResponsibles = $scope.parentScopeValues.customerResponsibles.concat(folder.customerResponsibles);
        }
        if (folder.replyAddresses) {
          $scope.parentScopeValues.replyAddresses = $scope.parentScopeValues.replyAddresses.concat(folder.replyAddresses);
        }
        if (folder.replyDomains) {
          $scope.parentScopeValues.replyDomains = $scope.parentScopeValues.replyDomains.concat(folder.replyDomains);
        }
        // manage rigths
        if (folder.readRightUsers) {
          $scope.parentScopeValues.readRightUsers = $scope.parentScopeValues.readRightUsers.concat(folder.readRightUsers);
        }
        if (folder.readRightGroups) {
          $scope.parentScopeValues.readRightGroups = $scope.parentScopeValues.readRightGroups.concat(folder.readRightGroups);
        }
        if (folder.writeRightUsers) {
          $scope.parentScopeValues.writeRightUsers = $scope.parentScopeValues.writeRightUsers.concat(folder.writeRightUsers);
        }
        if (folder.writeRightGroups) {
          $scope.parentScopeValues.writeRightGroups = $scope.parentScopeValues.writeRightGroups.concat(folder.writeRightGroups);
        }
        if (folder.moveRightUsers) {
          $scope.parentScopeValues.moveRightUsers = $scope.parentScopeValues.moveRightUsers.concat(folder.moveRightUsers);
        }
        if (folder.moveRightGroups) {
          $scope.parentScopeValues.moveRightGroups = $scope.parentScopeValues.moveRightGroups.concat(folder.moveRightGroups);
        }
      }
    };

    // utilisé pour mettre à jour $scope.selectedMailFolder.folderTableColumns si $scope.folderTableColumns change
    $scope.$watch("folderTableColumns", function(newValue, oldValue) {
      if (newValue != oldValue) {
        $scope.selectedMailFolder.folderTableColumns = [];
        angular.forEach(newValue, function(elem) {
          $scope.selectedMailFolder.folderTableColumns.push(elem.id);
        });
      }
    }, true);

    // fonction retournant l'ensemble des options disponibles
    $scope.getObjectsData = function(term, result) {
      var resultArray = [];
      angular.forEach($scope.tableMailFields, function(label, field) {
        resultArray.push({
          id: field,
          label: label
        });
      });
      result(resultArray);
    };

    // recursive find folder where user is already responsible
    var checkUserResponsible = function(folders, user) {
      var result;
      angular.forEach(folders, function(folder) {
        if (folder.customerResponsibles) {
          angular.forEach(folder.customerResponsibles, function(responsible) {
            if (responsible.topiaId == user.topiaId) {
              result = folder;
            }
          });
        }
        if (!result && folder.children) {
          result = checkUserResponsible(folder.children, user);
        }
      });
      return result;
    };

    // add customer responsible
    $scope.addCustomerResponsible = function() {
      
      // check it user is already responsible of another folder
      var otherFolder = checkUserResponsible($scope.mailFolders, $scope.newCustomerResponsible);
      if (angular.isDefined(otherFolder)) {
        if ($window.confirm("Cet utilisateur est déjà reponsable du dossier '" + otherFolder.$fullPath +
            "'. Voulez-vous continuer et changer son dossier de responsabilité ?")) {

          // remove from previous
          var index = otherFolder.customerResponsibles.indexOf($scope.newCustomerResponsible);
          otherFolder.customerResponsibles.splice(index, 1);

          // add to current
          $scope.selectedMailFolder.customerResponsibles.push($scope.newCustomerResponsible);
          delete $scope.newCustomerResponsible;
        }
      } else {
        $scope.selectedMailFolder.customerResponsibles.push($scope.newCustomerResponsible);
        delete $scope.newCustomerResponsible;
      }
    };

    // remove customer responsible
    $scope.removeCustomerResponsible = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce chargé de clientelle ?")) {
        $scope.selectedMailFolder.customerResponsibles.splice(index, 1);
      }
    };
    
    // add reply address
    $scope.addReplyAddress = function() {
      $scope.selectedMailFolder.replyAddresses.push($scope.newReplyAddress);
      delete $scope.newReplyAddress;
      $scope.addAddressForm.$setPristine();
    };

    // remove customer responsible
    $scope.removeReplyAddress = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer cette adresse ?")) {
        $scope.selectedMailFolder.replyAddresses.splice(index, 1);
      }
    };
    
    // add reply domain
    $scope.addReplyDomain = function() {
      $scope.selectedMailFolder.replyDomains.push($scope.newReplyDomain);
      delete $scope.newReplyDomain;
      $scope.addDomainForm.$setPristine();
    };

    // remove customer responsible
    $scope.removeReplyDomain = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce domaine ?")) {
        $scope.selectedMailFolder.replyDomains.splice(index, 1);
      }
    };

    // initialise la liste des etats d'attente avec celle des niveaux supérieurs
    $scope.initFolderEtatAttente = function() {
      if ($scope.selectedMailFolder.useCurrentLevelEtatAttente) {
        if ($scope.parentScopeValues.etatAttentes) {
          $scope.selectedMailFolder.etatAttentes = $scope.parentScopeValues.etatAttentes.slice(); // soft copy
        }
      } else {
        delete $scope.selectedMailFolder.etatAttentes;
      }
    };

    // selection/deselection d'un état d'attente possible pour ce dossier
    $scope.changeFolderEtatAttente = function(etatAttente) {
      var index = $scope.selectedMailFolder.etatAttentes.indexOf(etatAttente);
      if (index != -1) {
        $scope.selectedMailFolder.etatAttentes.splice(index, 1);
      } else {
        $scope.selectedMailFolder.etatAttentes.push(etatAttente);
      }
    };

    // initialise la liste des actions possibles avec celle des niveaux supérieurs
    $scope.initFolderColumns = function() {
      if ($scope.selectedMailFolder.useCurrentLevelTableColumns) {
        if ($scope.parentScopeValues.folderTableColumns) {
          $scope.selectedMailFolder.folderTableColumns = $scope.parentScopeValues.folderTableColumns.slice(); // soft copy
          
          // init select2 data
          $scope.folderTableColumns = [];
          angular.forEach($scope.selectedMailFolder.folderTableColumns, function(folderTableColumn) {
            $scope.folderTableColumns.push({
              id: folderTableColumn,
              label: $scope.tableMailFields[folderTableColumn]
            });
          });
        }
      } else {
        delete $scope.selectedMailFolder.folderTableColumns;
      }
    };

    // add user write right
    $scope.addRightUser = function() {
      $scope.selectedMailFolder.rightUsers.push($scope.newRightUser);
      delete $scope.newWriteRightUser;
    };

    // remove user write right
    $scope.removeRightUser = function(index) {
      if ($window.confirm("Êtes-vous sur de vouloir supprimer les droits de cet utilisateur ?")) {
        $scope.selectedMailFolder.rightUsers.splice(index, 1);
      }
    };
    
    // add group write right
    $scope.addRightGroup = function() {
      $scope.selectedMailFolder.rightGroups.push($scope.newRightGroup);
      delete $scope.newRightGroup;
    };

    // remove group write right
    $scope.removeWriteRightGroup = function(index) {
      if ($window.confirm("Êtes-vous sur de vouloir supprimer les droits de ce groupe ?")) {
        $scope.selectedMailFolder.rightGroups.splice(index, 1);
      }
    };
    
    //
    $scope.changeReadRightGroup = function(group) {
      var index = $scope.selectedMailFolder.readRightGroups.indexOf(group);
      if (index != -1) {
        $scope.selectedMailFolder.readRightGroups.splice(index, 1);
      } else {
        $scope.selectedMailFolder.readRightGroups.push(group);
      }
    };
    $scope.changeWriteRightGroup = function(group) {
      var index = $scope.selectedMailFolder.writeRightGroups.indexOf(group);
      if (index != -1) {
        $scope.selectedMailFolder.writeRightGroups.splice(index, 1);
      } else {
        $scope.selectedMailFolder.writeRightGroups.push(group);
      }
    };
    $scope.changeMoveRightGroup = function(group) {
      var index = $scope.selectedMailFolder.moveRightGroups.indexOf(group);
      if (index != -1) {
        $scope.selectedMailFolder.moveRightGroups.splice(index, 1);
      } else {
        $scope.selectedMailFolder.moveRightGroups.push(group);
      }
    };
    $scope.changeReadRightUser = function(user) {
      var index = $scope.selectedMailFolder.readRightUsers.indexOf(user);
      if (index != -1) {
        $scope.selectedMailFolder.readRightUsers.splice(index, 1);
      } else {
        $scope.selectedMailFolder.readRightUsers.push(user);
      }
    };
    $scope.changeWriteRightUser = function(user) {
      var index = $scope.selectedMailFolder.writeRightUsers.indexOf(user);
      if (index != -1) {
        $scope.selectedMailFolder.writeRightUsers.splice(index, 1);
      } else {
        $scope.selectedMailFolder.writeRightUsers.push(user);
      }
    };
    $scope.changeMoveRightUser = function(user) {
      var index = $scope.selectedMailFolder.moveRightUsers.indexOf(user);
      if (index != -1) {
        $scope.selectedMailFolder.moveRightUsers.splice(index, 1);
      } else {
        $scope.selectedMailFolder.moveRightUsers.push(user);
      }
    };
}]);


/**
 * Mail filter tab controller.
 */
ConfigurationModule.controller('ConfigurationFilterController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    //{Array} Current mail filter list
    $scope.mailFilters = ConfigurationData.mailFilters;
    //{Map} Folder mail fiters
    $scope.rootFolderMailFilters = {};
    //{Object} New accout empty filter
    $scope.newFilter = {};

    // replace filter instance with mailFolder filter instance to use same objects
    var updateMetaFilter = function() {
      angular.forEach($scope.mailFilters, function(filter) {
        // root folder
        angular.forEach($scope.mailFolders, function(mailFolder) {
          if (!$scope.rootFolderMailFilters.hasOwnProperty(mailFolder.topiaId)) {
            $scope.rootFolderMailFilters[mailFolder.topiaId] = [];
          }
          angular.forEach($scope.flatMailFolders[mailFolder.topiaId], function(subFolder) {
            if (subFolder.topiaId == filter.mailFolder.topiaId) {
              filter.mailFolder = subFolder;
  
              $scope.rootFolderMailFilters[subFolder.$rootFolder.topiaId].push(filter);
            }
          });
        });
      });
    };
    // update when root folder collection changes (and for init)
    $scope.$watchCollection("mailFolders", function(news, olds) {
      console.log("Udpate MetaFilter");
      $scope.rootFolderMailFilters = {};
      updateMetaFilter();
    });

    // option de la configuration 'sortable'
    $scope.sortableOptions = {
      stop: function(e, ui) {
        $scope.mailFilters = [];
        // update global $scope.mailFilters list
        angular.forEach($scope.rootFolderMailFilters, function(folderFilters, rootFolderId) {
          $scope.mailFilters = $scope.mailFilters.concat(folderFilters);
        });
      }
    };

    // add new filter action
    $scope.addNewFilter = function(rootMailFolder) {
      $scope.mailFilters.push($scope.newFilter);
      $scope.rootFolderMailFilters[rootMailFolder.topiaId].push($scope.newFilter);
      // clear form
      $scope.newFilter = {};
    };

    // remove filter
    $scope.removeFilter = function(rootMailFolder, filter) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce filtre ?")) {
        var index = $scope.mailFilters.indexOf(filter);
        $scope.mailFilters.splice(index, 1);
        var index2 = $scope.rootFolderMailFilters[rootMailFolder.topiaId].indexOf(filter);
        $scope.rootFolderMailFilters[rootMailFolder.topiaId].splice(index2, 1);
      }
    };
}]);


/**
 * Search tab controller.
 */
ConfigurationModule.controller('ConfigurationSearchController', ['$scope', 'ConfigurationData',
  function($scope, ConfigurationData) {
    //{Array} Options actuelle
    $scope.searchDisplayColumns = [];
    if ($scope.configuration.searchDisplayColumns) {
      angular.forEach($scope.configuration.searchDisplayColumns, function(searchDisplayColumn) {
        $scope.searchDisplayColumns.push({
          id: searchDisplayColumn,
          label: $scope.tableMailFields[searchDisplayColumn]
        });
      });
    }

    $scope.$watch("searchDisplayColumns", function(newValue, oldValue) {
      if (newValue) {
        $scope.configuration.searchDisplayColumns = [];
        angular.forEach(newValue, function(elem) {
          $scope.configuration.searchDisplayColumns.push(elem.id);
        });
      }
    });

    // fonction retournant l'ensemble des options disponibles
    $scope.getObjectsData = function(term, result) {
      var resultArray = [];
      angular.forEach($scope.tableMailFields, function(label, mailField) {
        resultArray.push({
          id: mailField,
          label: label
        });
      });
      result(resultArray);
    };
}]);


/**
 * Email accounts controller.
 */
ConfigurationModule.controller('ConfigurationEmailAccountsController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    //{Array} Email accounts
    $scope.emailAccounts = ConfigurationData.emailAccounts;
    //{Array} Port par défaut des protocols
    $scope.emailProtocolPorts = ConfigurationData.emailProtocolPorts;
    //{Object} New accout empty object
    $scope.newAccount = {};
    
    // ajout d'un nouveau compte
    $scope.addEmailAccount = function() {
      $scope.emailAccounts.push($scope.newAccount);
      $scope.newAccount = {};
      $scope.addEmailAccountForm.$setPristine();
    };
    
    // suppression d'un compte
    $scope.removeEmailAccount = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce compte email ?")) {
        $scope.emailAccounts.splice(index, 1);
      }
    };

    // selection d'un protocol
    $scope.$watch("newAccount.protocol", function(newValue, oldValue) {
      // auto remplissage du port par defaut
      if (newValue && ((oldValue && $scope.newAccount.port == $scope.emailProtocolPorts[oldValue]) || !$scope.newAccount.port)) {
        $scope.newAccount.port = $scope.emailProtocolPorts[newValue];
      }
    });
}]);


/**
 * Chef de groupe controller.
 */
ConfigurationModule.controller('ConfigurationChefGroupController', ['$scope', '$window', 'ConfigurationData',
  function($scope, $window, ConfigurationData) {
    //{Object} Chef de group en cours d'edition
    $scope.selectedGroupChef;
    //{Object} Nouveau group selectionné
    $scope.newManagedGroup;

    // change instances
    if (!$scope.configuration.chefs) {
      $scope.configuration.chefs = [];
    }
    angular.forEach($scope.groups, function(group) {
      angular.forEach($scope.configuration.chefs, function(chef) {
        if (chef.userGroup.topiaId == group.topiaId) {
          chef.userGroup = group;
        }
        // managedGroups is not necessary to change here
      });
    });

    // ajout d'un nouveau chef de groupe
    $scope.newGroupChef = function() {
      var groupChef = {
          managedGroups : []
      };
      $scope.configuration.chefs.push(groupChef);
      $scope.editGroupChef(groupChef);
    };

    // edition d'un chef de groupe
    $scope.editGroupChef = function(groupChef) {
      $scope.selectedGroupChef = groupChef;
    };

    // suppression d'un chef de groupe
    $scope.removeGroupChef = function(groupChef, index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce chef de groupe ?")) {
        $scope.configuration.chefs.splice(index, 1);
        if (groupChef == $scope.selectedGroupChef) {
          delete $scope.selectedGroupChef;
        }
      }
    };

    // Ajout d'un nouveau group géré
    $scope.addManagedGroup = function() {
      $scope.selectedGroupChef.managedGroups.push($scope.newManagedGroup);
      delete $scope.newManagedGroup;
    };
    
    // Suppression d'un group gérés
    $scope.removeManagedGroup = function(index) {
      if ($window.confirm("Êtes-vous sûr de vouloir supprimer ce groupe gérés ?")) {
        $scope.selectedGroupChef.managedGroups.splice(index, 1);
      }
    };
}]);
