/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter.ccitt;

final class PackedBitArray {
    private int bitCount;
    private byte[] data;

    PackedBitArray(int bitCount) {
        this.bitCount = bitCount;
        int byteCount = (bitCount + 7) / 8;
        this.data = new byte[byteCount];
    }

    private int byteOffset(int offset) {
        return offset / 8;
    }

    private int bitOffset(int offset) {
        return offset % 8;
    }

    public void set(int offset) {
        int byteOffset;
        int n = byteOffset = this.byteOffset(offset);
        this.data[n] = (byte)(this.data[n] | 1 << this.bitOffset(offset));
    }

    public void clear(int offset) {
        int byteOffset = this.byteOffset(offset);
        int bitOffset = this.bitOffset(offset);
        int n = byteOffset;
        this.data[n] = (byte)(this.data[n] & ~(1 << bitOffset));
    }

    public void setBits(int offset, int length, int bit) {
        if (bit == 0) {
            this.clearBits(offset, length);
        } else {
            this.setBits(offset, length);
        }
    }

    public void setBits(int offset, int length) {
        if (length == 0) {
            return;
        }
        int startBitOffset = this.bitOffset(offset);
        int firstByte = this.byteOffset(offset);
        int lastBitOffset = offset + length;
        if (lastBitOffset > this.getBitCount()) {
            throw new IndexOutOfBoundsException("offset + length > bit count");
        }
        int lastByte = this.byteOffset(lastBitOffset);
        int endBitOffset = this.bitOffset(lastBitOffset);
        if (firstByte == lastByte) {
            int mask = (1 << endBitOffset) - (1 << startBitOffset);
            int n = firstByte;
            this.data[n] = (byte)(this.data[n] | mask);
        } else {
            int n = firstByte;
            this.data[n] = (byte)(this.data[n] | 255 << startBitOffset);
            for (int i = firstByte + 1; i < lastByte; ++i) {
                this.data[i] = -1;
            }
            if (endBitOffset > 0) {
                int n2 = lastByte;
                this.data[n2] = (byte)(this.data[n2] | 255 >> 8 - endBitOffset);
            }
        }
    }

    public void clearBits(int offset, int length) {
        if (length == 0) {
            return;
        }
        int startBitOffset = offset % 8;
        int firstByte = this.byteOffset(offset);
        int lastBitOffset = offset + length;
        int lastByte = this.byteOffset(lastBitOffset);
        int endBitOffset = lastBitOffset % 8;
        if (firstByte == lastByte) {
            int mask = (1 << endBitOffset) - (1 << startBitOffset);
            int n = firstByte;
            this.data[n] = (byte)(this.data[n] & ~mask);
        } else {
            int n = firstByte;
            this.data[n] = (byte)(this.data[n] & ~(255 << startBitOffset));
            for (int i = firstByte + 1; i < lastByte; ++i) {
                this.data[i] = 0;
            }
            if (endBitOffset > 0) {
                int n2 = lastByte;
                this.data[n2] = (byte)(this.data[n2] & ~(255 >> 8 - endBitOffset));
            }
        }
    }

    public void clear() {
        this.clearBits(0, this.getBitCount());
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getByteCount() {
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return PackedBitArray.toBitString(this.data).substring(0, this.bitCount);
    }

    public static String toBitString(byte data) {
        byte[] buf = new byte[]{data};
        return PackedBitArray.toBitString(buf);
    }

    public static String toBitString(byte[] data) {
        return PackedBitArray.toBitString(data, 0, data.length);
    }

    public static String toBitString(byte[] data, int start, int len) {
        StringBuffer sb = new StringBuffer();
        int end = start + len;
        for (int x = start; x < end; ++x) {
            for (int i = 0; i < 8; ++i) {
                int mask = 1 << i;
                int value = data[x] & mask;
                sb.append(value != 0 ? (char)'1' : '0');
            }
        }
        return sb.toString();
    }
}

