/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.printing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.print.attribute.PrintRequestAttributeSet;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFPrinter {
    protected final PDDocument document;
    protected final PDFRenderer renderer;
    protected final PrinterJob printerJob;
    protected final Scaling scaling;
    protected final Orientation orientation;
    protected final boolean showPageBorder;
    protected final Paper paper;
    protected final float dpi;

    public PDFPrinter(PDDocument document) throws PrinterException {
        this(document, PrinterJob.getPrinterJob());
    }

    public PDFPrinter(PDDocument document, PrinterJob printerJob) throws PrinterException {
        this(document, printerJob, Scaling.SHRINK_TO_FIT, Orientation.AUTO, null, false, 0.0f);
    }

    public PDFPrinter(PDDocument document, Scaling scaling, Orientation orientation) throws PrinterException {
        this(document, PrinterJob.getPrinterJob(), scaling, orientation, null, false, 0.0f);
    }

    public PDFPrinter(PDDocument document, Scaling scaling, Orientation orientation, Paper paper) throws PrinterException {
        this(document, PrinterJob.getPrinterJob(), scaling, orientation, paper, false, 0.0f);
    }

    public PDFPrinter(PDDocument document, Scaling scaling, Orientation orientation, Paper paper, float dpi) throws PrinterException {
        this(document, PrinterJob.getPrinterJob(), scaling, orientation, paper, false, dpi);
    }

    public PDFPrinter(PDDocument document, PrinterJob printerJob, Scaling scaling, Orientation orientation, Paper paper, boolean showPageBorder, float dpi) throws PrinterException {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        if (printerJob == null) {
            throw new IllegalArgumentException("printerJob");
        }
        if (!document.getCurrentAccessPermission().canPrint()) {
            throw new PrinterException("You do not have permission to print this document");
        }
        this.document = document;
        this.renderer = new PDFRenderer(document);
        this.printerJob = printerJob;
        this.scaling = scaling;
        this.orientation = orientation;
        this.showPageBorder = showPageBorder;
        this.paper = paper != null ? paper : printerJob.defaultPage().getPaper();
        this.dpi = dpi;
    }

    public void silentPrint() throws PrinterException {
        this.silentPrint(this.printerJob);
    }

    public boolean silentPrint(PrintRequestAttributeSet attributes) throws PrinterException {
        return this.print(this.printerJob, attributes, true);
    }

    public void silentPrint(PrinterJob printerJob) throws PrinterException {
        this.print(printerJob, null, true);
    }

    public boolean print() throws PrinterException {
        return this.print(this.printerJob);
    }

    public boolean print(PrintRequestAttributeSet attributes) throws PrinterException {
        return this.print(this.printerJob, attributes);
    }

    public boolean print(PrinterJob printerJob) throws PrinterException {
        return this.print(printerJob, null, false);
    }

    public boolean print(PrinterJob printerJob, PrintRequestAttributeSet attributes) throws PrinterException {
        return this.print(printerJob, attributes, false);
    }

    private boolean print(PrinterJob job, PrintRequestAttributeSet attributes, boolean isSilent) throws PrinterException {
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        job.setPageable(this.getPageable());
        if (isSilent && attributes == null) {
            job.print();
            return true;
        }
        if (isSilent) {
            job.print(attributes);
            return true;
        }
        if (attributes == null) {
            if (job.printDialog()) {
                job.print();
                return true;
            }
        } else if (job.printDialog(attributes)) {
            job.print(attributes);
            return true;
        }
        return false;
    }

    public Pageable getPageable() {
        return new PDFPageable();
    }

    private PDRectangle getRotatedCropBox(PDPage page) {
        PDRectangle cropBox = page.getCropBox();
        int rotationAngle = page.getRotation();
        if (rotationAngle == 90 || rotationAngle == 270) {
            return new PDRectangle(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
        }
        return cropBox;
    }

    protected class PDFPrintable
    implements Printable {
        protected PDFPrintable() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex < 0 || pageIndex >= PDFPrinter.this.document.getNumberOfPages()) {
                return 1;
            }
            try {
                double scaleY;
                double scaleX;
                Graphics2D graphics2D = (Graphics2D)graphics;
                PDPage page = PDFPrinter.this.document.getPage(pageIndex);
                PDRectangle cropBox = PDFPrinter.this.getRotatedCropBox(page);
                double imageableWidth = pageFormat.getImageableWidth();
                double imageableHeight = pageFormat.getImageableHeight();
                double scale = 1.0;
                if (PDFPrinter.this.scaling != Scaling.ACTUAL_SIZE && (scale = Math.min(scaleX = imageableWidth / (double)cropBox.getWidth(), scaleY = imageableHeight / (double)cropBox.getHeight())) > 1.0 && PDFPrinter.this.scaling == Scaling.SHRINK_TO_FIT) {
                    scale = 1.0;
                }
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                graphics2D.translate((imageableWidth - (double)cropBox.getWidth() * scale) / 2.0, (imageableHeight - (double)cropBox.getHeight() * scale) / 2.0);
                Graphics2D printerGraphics = null;
                BufferedImage image = null;
                if (PDFPrinter.this.dpi > 0.0f) {
                    float dpiScale = PDFPrinter.this.dpi / 72.0f;
                    image = new BufferedImage((int)(imageableWidth * (double)dpiScale), (int)(imageableHeight * (double)dpiScale), 2);
                    printerGraphics = graphics2D;
                    graphics2D = image.createGraphics();
                    printerGraphics.scale(scale / (double)dpiScale, scale / (double)dpiScale);
                    scale = dpiScale;
                }
                AffineTransform transform = (AffineTransform)graphics2D.getTransform().clone();
                graphics2D.setBackground(Color.WHITE);
                PDFPrinter.this.renderer.renderPageToGraphics(pageIndex, graphics2D, (float)scale);
                if (PDFPrinter.this.showPageBorder) {
                    graphics2D.setTransform(transform);
                    graphics2D.setClip(0, 0, (int)imageableWidth, (int)imageableHeight);
                    graphics2D.scale(scale, scale);
                    graphics2D.setColor(Color.GRAY);
                    graphics2D.setStroke(new BasicStroke(0.5f));
                    graphics.drawRect(0, 0, (int)cropBox.getWidth(), (int)cropBox.getHeight());
                }
                if (printerGraphics != null) {
                    printerGraphics.setBackground(Color.WHITE);
                    printerGraphics.clearRect(0, 0, image.getWidth(), image.getHeight());
                    printerGraphics.drawImage((Image)image, 0, 0, null);
                    graphics2D.dispose();
                }
                return 0;
            }
            catch (IOException e) {
                throw new PrinterIOException(e);
            }
        }
    }

    protected class PDFPageable
    implements Pageable {
        protected PDFPageable() {
        }

        @Override
        public int getNumberOfPages() {
            return PDFPrinter.this.document.getNumberOfPages();
        }

        @Override
        public PageFormat getPageFormat(int pageIndex) {
            PageFormat format = PDFPrinter.this.printerJob.defaultPage();
            PDPage page = PDFPrinter.this.document.getPage(pageIndex);
            if (PDFPrinter.this.orientation == Orientation.AUTO) {
                PDRectangle cropBox = PDFPrinter.this.getRotatedCropBox(page);
                if (cropBox.getWidth() > cropBox.getHeight()) {
                    format.setOrientation(0);
                } else {
                    format.setOrientation(1);
                }
            } else if (PDFPrinter.this.orientation == Orientation.LANDSCAPE) {
                format.setOrientation(0);
            } else if (PDFPrinter.this.orientation == Orientation.PORTRAIT) {
                format.setOrientation(1);
            }
            if (PDFPrinter.this.paper != null) {
                format.setPaper(PDFPrinter.this.paper);
            }
            return format;
        }

        @Override
        public Printable getPrintable(int i) {
            if (i >= this.getNumberOfPages()) {
                throw new IndexOutOfBoundsException(i + " >= " + this.getNumberOfPages());
            }
            return new PDFPrintable();
        }
    }
}

