/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.ExternalFonts;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.util.Matrix;

public class PDCIDFontType0
extends PDCIDFont {
    private static final Log LOG = LogFactory.getLog(PDCIDFontType0.class);
    private final CFFCIDFont cidFont;
    private final CFFType1Font t1Font;
    private final Map<Integer, Float> glyphHeights = new HashMap<Integer, Float>();
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private Float avgWidth = null;
    private Matrix fontMatrix;
    private final AffineTransform fontMatrixTransform;

    public PDCIDFontType0(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        super(fontDictionary, parent);
        PDStream ff3Stream;
        PDFontDescriptor fd = this.getFontDescriptor();
        byte[] bytes = null;
        if (fd != null && (ff3Stream = fd.getFontFile3()) != null) {
            bytes = IOUtils.toByteArray(ff3Stream.createInputStream());
        }
        boolean fontIsDamaged = false;
        CFFFont cffFont = null;
        if (bytes != null && bytes.length > 0 && (bytes[0] & 0xFF) == 37) {
            LOG.error((Object)("Unsupported: Type1 font instead of CFF in " + fd.getFontName()));
            fontIsDamaged = true;
        } else if (bytes != null) {
            CFFParser cffParser = new CFFParser();
            try {
                cffFont = (CFFFont)cffParser.parse(bytes).get(0);
            }
            catch (IOException e) {
                LOG.error((Object)("Can't read the embedded CFF font " + fd.getFontName()), (Throwable)e);
                fontIsDamaged = true;
            }
        }
        if (cffFont != null) {
            if (cffFont instanceof CFFCIDFont) {
                this.cidFont = (CFFCIDFont)cffFont;
                this.t1Font = null;
            } else {
                this.cidFont = null;
                this.t1Font = (CFFType1Font)cffFont;
            }
            this.isEmbedded = true;
            this.isDamaged = false;
        } else {
            CFFCIDFont cidSub = ExternalFonts.getCFFCIDFont(this.getBaseFont());
            if (cidSub != null) {
                this.cidFont = cidSub;
                this.t1Font = null;
            } else {
                COSDictionary cidSystemInfo = (COSDictionary)this.dict.getDictionaryObject(COSName.CIDSYSTEMINFO);
                String registryOrdering = null;
                if (cidSystemInfo != null) {
                    String registry = cidSystemInfo.getNameAsString(COSName.REGISTRY);
                    String ordering = cidSystemInfo.getNameAsString(COSName.ORDERING);
                    if (registry != null && ordering != null) {
                        registryOrdering = registry + "-" + ordering;
                    }
                }
                this.cidFont = cidSub = ExternalFonts.getCFFCIDFontFallback(registryOrdering, this.getFontDescriptor());
                this.t1Font = null;
                if (cidSub.getName().equals("AdobeBlank")) {
                    if (!fontIsDamaged) {
                        LOG.error((Object)("Missing CID-keyed font " + this.getBaseFont()));
                    }
                } else {
                    LOG.warn((Object)("Using fallback for CID-keyed font " + this.getBaseFont()));
                }
            }
            this.isEmbedded = false;
            this.isDamaged = fontIsDamaged;
        }
        this.fontMatrixTransform = this.getFontMatrix().createAffineTransform();
        this.fontMatrixTransform.scale(1000.0, 1000.0);
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List numbers = this.cidFont != null ? this.cidFont.getFontMatrix() : this.t1Font.getFontMatrix();
            this.fontMatrix = numbers != null && numbers.size() == 6 ? new Matrix(((Number)numbers.get(0)).floatValue(), ((Number)numbers.get(1)).floatValue(), ((Number)numbers.get(2)).floatValue(), ((Number)numbers.get(3)).floatValue(), ((Number)numbers.get(4)).floatValue(), ((Number)numbers.get(5)).floatValue()) : new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        return this.fontMatrix;
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.cidFont != null) {
            return this.cidFont.getFontBBox();
        }
        return this.t1Font.getFontBBox();
    }

    public CFFFont getCFFFont() {
        if (this.cidFont != null) {
            return this.cidFont;
        }
        return this.t1Font;
    }

    public Type2CharString getType2CharString(int cid) throws IOException {
        if (this.cidFont != null) {
            return this.cidFont.getType2CharString(cid);
        }
        return this.t1Font.getType2CharString(cid);
    }

    @Override
    public int codeToCID(int code) {
        return this.parent.getCMap().toCID(code);
    }

    @Override
    public int codeToGID(int code) {
        int cid = this.codeToCID(code);
        if (this.cidFont != null) {
            return this.cidFont.getCharset().getGIDForCID(cid);
        }
        return cid;
    }

    @Override
    public byte[] encode(int unicode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int cid = this.codeToCID(code);
        int width = this.getType2CharString(cid).getWidth();
        Point2D.Float p = new Point2D.Float(width, 0.0f);
        this.fontMatrixTransform.transform(p, p);
        return (float)((Point2D)p).getX();
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    @Override
    public float getHeight(int code) throws IOException {
        int cid = this.codeToCID(code);
        float height = 0.0f;
        if (!this.glyphHeights.containsKey(cid)) {
            height = (float)this.getType2CharString(cid).getBounds().getHeight();
            this.glyphHeights.put(cid, Float.valueOf(height));
        }
        return height;
    }

    @Override
    public float getAverageFontWidth() {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    private float getAverageCharacterWidth() {
        return 500.0f;
    }
}

