package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class DemandGroupUI extends AbstractToolbarPopupUI<com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel, DemandGroupUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz08TQRgdVlooRVEIFQImBT2gMdvGxBNG+dFUIUUNlYTYi9PuUAZnZ8bZWbtoNP4J/gl692LizZPx4NmDF+O/YIwHr8ZvpqVbYAnEHrbNfN9735uv7+27nygVKDSzg6PIVSHX1Cfu6uLm5r36DmnoEgkaikotFGp/+hzk1FDW654HGl2sVQy80IEXloUvBSe8Bz1fQUOB3mUk2CZEa3RhP6IRBIVqtzwfyVDtsXZFJbG++f3Lee29eusgFElQl4ar5I9DxTfpryCHehqNwqSnuMAwb4IMRXkT9J42Z8sMB8Fd7JMn6CUaqKC0xArINJo9+ZUth8VHUqOxphKhJF6J+Jh7JYqZaGpUaQjf3VKYNyjeYiRyt3CkhY8pc0PqBi2Q5DYE1zDB9SySdL4tndtmu21+b6xIacelNUr5wiNMo8X/oG9Tko2VNcMRc/bXhber0YxQTXcHfPBYC9mmiNzVzQdUM+Ldx7wXMunF8pYAXW0owZhp0ui8WXPU0bAaVwx0pMuQAa3cssK/tQ9hD03XaLc52zNOo6kjhOI6s0PGJZhmap9pwI5ubMfYL301lFIhHGs0UTvs4HUotb07ccC7htBW/+bGvn388aG8Z1iTvfHE1p68gZGkEpIoTc3okbZbQ01ZYQ3L+RrKBIRBWG0YpxOEVTtlEAfzzhm4a+DuHRxsA0Vq4Punz7lHX08hp4yGmMBeGZv+FZTR2wq2IJgXyVsLVtFwaxCeZ4020OLjiPqhvy5ayyI0wXCuFSPYwHTCBroy6pkvf8aq7xf2tuCAqskj2+NNpB6iNOWMcmKD28lkYlCzMiChJ+LsJaURgT1ySwTzMmWaKOMICHJdLImoY94rpmXYtBwo5O3zUtJOsj7lZidV+gzMM/s8z0krb3eOW9otwfV4QAWfu14sXs0XL+dfRKHhmjPoztDk14Q8fnZKm/yB6eOA94TBtdWkcTbUJ+AfJB7VZk8A0SpM5OqN3wko0wzvihCcc+aGhzXO1yn3IKM3D1H3mWcOGP8Bi/v/4LQGAAA=";
    private static final Log log = LogFactory.getLog(DemandGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTable demandGroup;
    protected JScrollPane demandGroupBodyScrollPane;
    protected DemandGroupUI groupedDemandDialog = this;
    protected final DemandGroupUIHandler handler = createHandler();
    protected JPanel mainPanel;
    protected DemandeUIModel model;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandGroupUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI() {
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTable getDemandGroup() {
        return demandGroup;
    }

    public JScrollPane getDemandGroupBodyScrollPane() {
        return demandGroupBodyScrollPane;
    }

    public DemandGroupUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(demandGroupBodyScrollPane);
    }

    protected void addChildrenToDemandGroupBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        demandGroupBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(demandGroup, BorderLayout.CENTER);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.demandGroup.title"));
    }

    protected void createDemandGroup() {
        $objectMap.put("demandGroup", demandGroup = new JXTable());
        
        demandGroup.setName("demandGroup");
        demandGroup.setEditable(true);
    }

    protected void createDemandGroupBodyScrollPane() {
        $objectMap.put("demandGroupBodyScrollPane", demandGroupBodyScrollPane = new JScrollPane());
        
        demandGroupBodyScrollPane.setName("demandGroupBodyScrollPane");
    }

    protected DemandGroupUIHandler createHandler() {
        return new DemandGroupUIHandler();
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeUIModel.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToDemandGroupBodyScrollPane();
        addChildrenToMainPanel();
        
        // apply 2 property setters
        setMinimumSize( new java.awt.Dimension(500, 0) );
        // late initializer
        groupedDemandDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("groupedDemandDialog", groupedDemandDialog);
        createModel();
        createDemandGroupBodyScrollPane();
        createMainPanel();
        createDemandGroup();
        // inline creation of groupedDemandDialog
        setName("groupedDemandDialog");
        
        $completeSetup();
        handler.afterInit(this);
    }

}