/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommand;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailLock;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.persistence.entities.SearchFilter;
import com.franciaflex.faxtomail.services.FaxToMailService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.services.service.exceptions.InvalidClientException;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportResult;
import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.EmailException;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public interface EmailService
extends FaxToMailService {
    public Email getEmailById(String var1);

    public Email getFullEmailById(String var1);

    public Email getFullEmailById(String var1, FaxToMailUser var2);

    public Email saveEmail(Email var1, FaxToMailUser var2, String ... var3) throws InvalidClientException;

    public Email saveEmail(Email var1, Collection<Attachment> var2, Collection<Reply> var3, String var4, FaxToMailUser var5, String ... var6) throws InvalidClientException;

    public void transmitPendingDemandsToEdi();

    public Set<Object> getDistinctValues(MailFolder var1, String[] var2, boolean var3);

    public PaginationResult<Email> getEmailForFolder(MailFolder var1, FaxToMailUser var2, EmailFilter var3, PaginationParameter var4);

    public List<MailFolder> getChildrenRecursively(MailFolder var1);

    public Map<Range, Long[]> computeQuantitiesByRange(MailFolder var1);

    public Email addToHistory(String var1, HistoryType var2, FaxToMailUser var3, Date var4, String ... var5);

    public Email openEmail(String var1, FaxToMailUser var2, boolean var3) throws FolderNotReadableException;

    public Email lockEmail(String var1, FaxToMailUser var2) throws AlreadyLockedMailException, FolderNotReadableException;

    public void unlockEmail(String var1);

    public PaginationResult<Email> search(SearchFilter var1, FaxToMailUser var2, PaginationParameter var3);

    public Collection<Email> searchArchives(String var1, String var2);

    public Email groupEmails(String var1, String var2, FaxToMailUser var3);

    public Email reply(String var1, String var2, String var3, String var4, String var5, String var6, Collection<AttachmentFile> var7, String var8, FaxToMailUser var9) throws EmailException, MessagingException, IOException;

    public ReplyContent getReplyContent(String var1);

    public void transmit(Collection<String> var1, MailFolder var2, FaxToMailUser var3);

    public AttachmentFile getAttachmentFileFromStream(InputStream var1);

    public AttachmentFile getAttachmentFile(String var1, boolean var2);

    public List<MailLock> getAllMailLocks();

    public void unlockMails(List<String> var1);

    public void rejectEmail(String var1, String var2, String var3, String var4) throws EmailException, MessagingException, IOException;

    public void updateRangeRowsWithEdiReturns();

    public OriginalEmail originalEmailFromMessage(MimeMessage var1, Charset var2) throws MessagingException, IOException;

    public AttachmentFile getEmailDetailAsAttachment(Email var1);

    public long getArchivedMailCount();

    public ArchiveImportResult importArchive(InputStream var1, File var2);

    public String decomposeMultipartEmail(List<Attachment> var1, Part var2) throws Exception;

    public Attachment convertIfNecessary(Attachment var1) throws IOException;

    public Attachment convertToPdf(Attachment var1, ExtensionCommand var2) throws IOException;

    public Attachment convertTextToPdf(String var1, String var2) throws IOException, DocumentException;

    public Attachment convertHTMLToPdf(List<Attachment> var1, String var2, String var3) throws IOException;
}

