/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@SdkInternalApi
public class GetObjectInterceptor
implements ExecutionInterceptor {
    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse response = context.response();
        if (!(response instanceof GetObjectResponse)) {
            return response;
        }
        return this.fixContentRange(response, context.httpResponse());
    }

    private SdkResponse fixContentRange(SdkResponse sdkResponse, SdkHttpResponse httpResponse) {
        GetObjectResponse getObjectResponse = (GetObjectResponse)sdkResponse;
        if (getObjectResponse.contentRange() != null) {
            return getObjectResponse;
        }
        Optional xAmzContentRange = httpResponse.firstMatchingHeader("x-amz-content-range");
        if (!xAmzContentRange.isPresent()) {
            return getObjectResponse;
        }
        return (SdkResponse)getObjectResponse.copy(r -> r.contentRange((String)xAmzContentRange.get()));
    }
}

