/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbSecurityGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbSecurityGroupRequest> {
    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSecurityGroupName").getter(CreateDbSecurityGroupRequest.getter(CreateDbSecurityGroupRequest::dbSecurityGroupName)).setter(CreateDbSecurityGroupRequest.setter(Builder::dbSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSecurityGroupDescription").getter(CreateDbSecurityGroupRequest.getter(CreateDbSecurityGroupRequest::dbSecurityGroupDescription)).setter(CreateDbSecurityGroupRequest.setter(Builder::dbSecurityGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDbSecurityGroupRequest.getter(CreateDbSecurityGroupRequest::tags)).setter(CreateDbSecurityGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SECURITY_GROUP_NAME_FIELD, DB_SECURITY_GROUP_DESCRIPTION_FIELD, TAGS_FIELD));
    private final String dbSecurityGroupName;
    private final String dbSecurityGroupDescription;
    private final List<Tag> tags;

    private CreateDbSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.tags = builder.tags;
    }

    public final String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public final String dbSecurityGroupDescription() {
        return this.dbSecurityGroupDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbSecurityGroupRequest)) {
            return false;
        }
        CreateDbSecurityGroupRequest other = (CreateDbSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(this.dbSecurityGroupDescription(), other.dbSecurityGroupDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbSecurityGroupRequest").add("DBSecurityGroupName", (Object)this.dbSecurityGroupName()).add("DBSecurityGroupDescription", (Object)this.dbSecurityGroupDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupName()));
            }
            case "DBSecurityGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbSecurityGroupRequest, T> g) {
        return obj -> g.apply((CreateDbSecurityGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbSecurityGroupName;
        private String dbSecurityGroupDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbSecurityGroupRequest model) {
            super(model);
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.dbSecurityGroupDescription(model.dbSecurityGroupDescription);
            this.tags(model.tags);
        }

        public final String getDbSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final String getDbSecurityGroupDescription() {
            return this.dbSecurityGroupDescription;
        }

        public final void setDbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        @Override
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbSecurityGroupRequest build() {
            return new CreateDbSecurityGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbSecurityGroupRequest> {
        public Builder dbSecurityGroupName(String var1);

        public Builder dbSecurityGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

