/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.http.HttpStreamsClientHandler;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.ResponseHandler;
import software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;

@SdkInternalApi
public class HandlerRemovingChannelPool
implements ChannelPool {
    private final ChannelPool delegate;

    public HandlerRemovingChannelPool(ChannelPool delegate) {
        this.delegate = delegate;
    }

    public Future<Channel> acquire() {
        return this.delegate.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegate.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        this.removePerRequestHandlers(channel);
        return this.delegate.release(channel);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        this.removePerRequestHandlers(channel);
        return this.delegate.release(channel, promise);
    }

    public void close() {
        this.delegate.close();
    }

    private void removePerRequestHandlers(Channel channel) {
        channel.attr(ChannelAttributeKey.IN_USE).set((Object)false);
        if (channel.isOpen() || channel.isRegistered()) {
            ChannelUtils.removeIfExists(channel.pipeline(), HttpStreamsClientHandler.class, ResponseHandler.class, ReadTimeoutHandler.class, WriteTimeoutHandler.class);
        }
    }
}

