/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.support;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.maven.plugin.support.BuildContextHolder;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeHandler {
    private WroManagerFactory managerFactory;
    private Log log;
    private BuildContextHolder buildContextHolder;
    private BuildContext buildContext;
    private File buildDirectory;
    private boolean incrementalBuildEnabled;

    public static ResourceChangeHandler create(WroManagerFactory managerFactory, Log log) {
        Validate.notNull((Object)managerFactory, (String)"WroManagerFactory was not set", (Object[])new Object[0]);
        Validate.notNull((Object)log, (String)"Log was not set", (Object[])new Object[0]);
        return new ResourceChangeHandler().setManagerFactory(managerFactory).setLog(log);
    }

    private ResourceChangeHandler() {
    }

    public boolean isResourceChanged(Resource resource) {
        Validate.notNull((Object)resource, (String)"Invalid resource provided", (Object[])new Object[0]);
        WroManager manager = (WroManager)this.getManagerFactory().create();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        AtomicBoolean changeDetected = new AtomicBoolean(false);
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
            String previousFingerprint = this.getBuildContextHolder().getValue(resource.getUri());
            boolean newValue = fingerprint != null && !fingerprint.equals(previousFingerprint);
            changeDetected.set(newValue);
            if (!changeDetected.get() && resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(locatorFactory.locate(resource.getUri()));
                this.getLog().debug((CharSequence)("Check @import directive from " + resource));
                this.detectChangeForCssImports(resource, reader, changeDetected);
            }
            return changeDetected.get();
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("failed to check for delta resource: " + resource));
            return false;
        }
    }

    private void detectChangeForCssImports(Resource resource, Reader reader, final AtomicBoolean changeDetected) throws IOException {
        this.forEachCssImportApply(new Function<String, Void>(){

            public Void apply(String importedUri) throws Exception {
                boolean isImportChanged = ResourceChangeHandler.this.isResourceChanged(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                ResourceChangeHandler.this.getLog().debug((CharSequence)("\tisImportChanged: " + isImportChanged));
                if (isImportChanged) {
                    changeDetected.set(true);
                    throw new WroRuntimeException("Change detected. No need to continue processing");
                }
                return null;
            }
        }, resource, reader);
    }

    public void remember(Resource resource) {
        WroManager manager = (WroManager)this.getManagerFactory().create();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
            this.getBuildContextHolder().setValue(resource.getUri(), fingerprint);
            this.getLog().debug((CharSequence)("Persist fingerprint for resource '" + resource.getUri() + "' : " + fingerprint));
            if (resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(locatorFactory.locate(resource.getUri()));
                this.getLog().debug((CharSequence)("Check @import directive from " + resource));
                this.persistFingerprintsForCssImports(resource, reader);
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("could not check fingerprint of resource: " + resource));
        }
    }

    private void persistFingerprintsForCssImports(Resource resource, Reader reader) throws IOException {
        this.forEachCssImportApply(new Function<String, Void>(){

            public Void apply(String importedUri) throws Exception {
                ResourceChangeHandler.this.remember(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                return null;
            }
        }, resource, reader);
    }

    private void forEachCssImportApply(Function<String, Void> func, Resource resource, Reader reader) throws IOException {
        ResourcePreProcessor processor = this.createCssImportProcessor(func);
        InjectorBuilder.create((WroManagerFactory)this.getManagerFactory()).build().inject((Object)processor);
        processor.process(resource, reader, (Writer)new StringWriter());
    }

    private ResourcePreProcessor createCssImportProcessor(final Function<String, Void> func) {
        AbstractCssImportPreProcessor cssImportProcessor = new AbstractCssImportPreProcessor(){

            protected void onImportDetected(String importedUri) {
                ResourceChangeHandler.this.getLog().debug((CharSequence)("Found @import " + importedUri));
                try {
                    func.apply((Object)importedUri);
                    ResourceChangeHandler.this.remember(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                }
                catch (Exception e) {
                    ResourceChangeHandler.this.getLog().error((CharSequence)("Cannot apply a function on @import resource: " + importedUri + ". Ignoring it."), (Throwable)e);
                }
                ResourceChangeHandler.this.remember(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
            }

            protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
                return "";
            }

            public String toString() {
                return CssImportPreProcessor.class.getSimpleName();
            }
        };
        ExceptionHandlingProcessorDecorator processor = new ExceptionHandlingProcessorDecorator(cssImportProcessor){

            protected boolean isIgnoreFailingProcessor() {
                return true;
            }
        };
        return processor;
    }

    private BuildContextHolder getBuildContextHolder() {
        if (this.buildContextHolder == null) {
            this.buildContextHolder = new BuildContextHolder(this.buildContext, this.buildDirectory);
            this.buildContextHolder.setIncrementalBuildEnabled(this.incrementalBuildEnabled);
        }
        return this.buildContextHolder;
    }

    @VisibleForTesting
    void setBuildContextHolder(BuildContextHolder buildContextHolder) {
        this.buildContextHolder = buildContextHolder;
    }

    private WroManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public Log getLog() {
        return this.log;
    }

    public ResourceChangeHandler setManagerFactory(WroManagerFactory wroManagerFactory) {
        this.managerFactory = wroManagerFactory;
        return this;
    }

    public ResourceChangeHandler setLog(Log log) {
        this.log = log;
        return this;
    }

    public ResourceChangeHandler setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
        return this;
    }

    public ResourceChangeHandler setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
        return this;
    }

    public ResourceChangeHandler setIncrementalBuildEnabled(boolean incrementalBuildEnabled) {
        this.incrementalBuildEnabled = incrementalBuildEnabled;
        return this;
    }

    public boolean isIncrementalBuild() {
        return this.getBuildContextHolder().isIncrementalBuild();
    }

    public void destroy() {
        this.getBuildContextHolder().destroy();
    }

    public void forget(Resource resource) {
        if (resource != null) {
            this.getBuildContextHolder().setValue(resource.getUri(), null);
        }
    }
}

