/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.js.AbstractLinterProcessor;
import ro.isdc.wro.extensions.processor.js.JsHintProcessor;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractSingleProcessorMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class JsHintMojo
extends AbstractSingleProcessorMojo {
    private File reportFile;
    private LintReport<LinterError> lintReport;

    protected ResourcePreProcessor createResourceProcessor() {
        AbstractLinterProcessor processor = new JsHintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                JsHintMojo.this.getLog().info((CharSequence)("processing resource: " + resource));
                super.process(resource, reader, (Writer)new StringWriter());
            }

            protected void onException(WroRuntimeException e) {
                JsHintMojo.this.onException((Exception)e);
            }

            protected void onLinterException(LinterException e, Resource resource) {
                String errorMessage = String.format("%s errors found while processing resource: %s. Errors are: %s", e.getErrors().size(), resource, e.getErrors());
                JsHintMojo.this.getLog().error((CharSequence)errorMessage);
                JsHintMojo.this.lintReport.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (!JsHintMojo.this.isFailNever()) {
                    throw new WroRuntimeException("Errors found when validating resource: " + resource);
                }
            }
        }.setOptionsAsString(this.getOptions());
        return processor;
    }

    protected void onBeforeExecute() {
        this.lintReport = new LintReport();
        FileUtils.deleteQuietly((File)this.reportFile);
    }

    protected void onAfterExecute() {
        if (this.reportFile != null) {
            try {
                this.reportFile.getParentFile().mkdirs();
                this.reportFile.createNewFile();
                this.getLog().debug((CharSequence)("creating report at location: " + this.reportFile));
                ReportXmlFormatter.createForLinterError(this.lintReport, (ReportXmlFormatter.FormatterType)ReportXmlFormatter.FormatterType.LINT).write((OutputStream)new FileOutputStream(this.reportFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not create report file: " + this.reportFile), (Throwable)e);
            }
        }
    }

    void onException(Exception e) {
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }
}

