/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.URL;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ExtendletContext;

public abstract class ExtendletLoader
implements Loader {
    private static final Log log = Log.lookup((Class)ExtendletLoader.class);
    private int _checkPeriod = ExtendletLoader.getInitCheckPeriod();

    protected ExtendletLoader() {
    }

    protected String getRealPath(String path) {
        return path;
    }

    public boolean shallCheck(Object src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(Object src) {
        if (this.getCheckPeriod() < 0) {
            return 1L;
        }
        try {
            URL url = this.getExtendletContext().getResource((String)src);
            return url != null ? url.openConnection().getLastModified() : -1L;
        }
        catch (Throwable ex) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object load(Object src) throws Exception {
        Object ex2;
        String path = this.getRealPath((String)src);
        InputStream is = null;
        if (this.getCheckPeriod() >= 0) {
            try {
                URL real = this.getExtendletContext().getResource(path);
                if (real != null) {
                    is = real.openStream();
                }
            }
            catch (Throwable ex2) {
                log.warningBriefly("Unable to read from URL: " + path, ex2);
            }
        }
        if (is == null && (is = this.getExtendletContext().getResourceAsStream(path)) == null) {
            return null;
        }
        try {
            ex2 = this.parse(is, path);
        }
        catch (Throwable ex2) {
            try {
                log.realCauseBriefly("Failed to parse " + path, ex2);
                Object var5_8 = null;
                return var5_8;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable ex3) {}
            }
        }
        try {
            is.close();
            return ex2;
        }
        catch (Throwable ex2) {
            // empty catch block
        }
        return ex2;
    }

    protected abstract Object parse(InputStream var1, String var2) throws Exception;

    protected abstract ExtendletContext getExtendletContext();

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    private static int getInitCheckPeriod() {
        int v = Library.getIntProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod", (int)-1);
        return v > 0 ? v * 1000 : v;
    }
}

