/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.zkoss.lang.SystemException;
import org.zkoss.util.resource.Locator;

public class ServletContextLocator
implements Locator {
    private final ServletContext _ctx;
    private final String _dir;

    public ServletContextLocator(ServletContext ctx) {
        this(ctx, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir) {
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        if (dir != null) {
            int len = dir.length();
            if (len == 0) {
                dir = null;
            } else {
                if (dir.charAt(0) != '/') {
                    throw new IllegalArgumentException(dir);
                }
                if (dir.charAt(len - 1) != '/') {
                    dir = dir + '/';
                }
            }
        }
        this._ctx = ctx;
        this._dir = dir;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    private String fixName(String name) {
        return this._dir != null && name.length() > 0 && name.charAt(0) != '/' ? this._dir + name : name;
    }

    public String getDirectory() {
        return this._dir;
    }

    public URL getResource(String name) {
        try {
            return this._ctx.getResource(this.fixName(name));
        }
        catch (MalformedURLException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public InputStream getResourceAsStream(String name) {
        return this._ctx.getResourceAsStream(this.fixName(name));
    }

    public int hashCode() {
        return this._ctx.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ServletContextLocator && ((ServletContextLocator)o)._ctx.equals(this._ctx);
    }
}

