/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.jsp;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Classes;
import org.zkoss.util.CacheMap;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.servlet.jsp.Jsps;

public final class JspLoaderServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)JspLoaderServlet.class);
    private final Map _jspServlets = new JspCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Servlet getJspServlet(String servletPath) throws ServletException {
        Map map;
        WaitLock lock = null;
        while (true) {
            Object o;
            map = this._jspServlets;
            synchronized (map) {
                o = this._jspServlets.get(servletPath);
                if (o == null) {
                    lock = new WaitLock();
                    this._jspServlets.put(servletPath, lock);
                }
            }
            if (o instanceof Servlet) {
                return (Servlet)o;
            }
            if (o == null) break;
            if (((WaitLock)o).waitUntilUnlock(300000)) continue;
            log.warning("Take too long to wait loading JSP: " + servletPath + "\nTry to load this page again automatically...");
        }
        try {
            String className = Jsps.mapJspToJavaName(servletPath);
            if (log.finerable()) {
                log.finer("Loading jsp: " + className + " path=" + servletPath);
            }
            Servlet servlet = (Servlet)Classes.newInstanceByThread((String)className);
            servlet.init(this.getServletConfig());
            Map map2 = this._jspServlets;
            synchronized (map2) {
                this._jspServlets.put(servletPath, servlet);
            }
            map2 = servlet;
            return map2;
        }
        catch (Throwable ex) {
            map = this._jspServlets;
            synchronized (map) {
                this._jspServlets.remove(servletPath);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            throw new ServletException(ex);
        }
        finally {
            lock.unlock();
        }
    }

    protected void service(HttpServletRequest hreq, HttpServletResponse hres) throws IOException, ServletException {
        this.getJspServlet(Https.getThisServletPath((ServletRequest)hreq)).service((ServletRequest)hreq, (ServletResponse)hres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map map = this._jspServlets;
        synchronized (map) {
            Iterator it = this._jspServlets.values().iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (!(val instanceof Servlet)) continue;
                ((Servlet)val).destroy();
            }
            this._jspServlets.clear();
        }
    }

    private static class JspCache
    extends CacheMap {
        JspCache() {
            this.setMaxSize(500);
            this.setLifetime(3600000);
        }

        protected void onExpunge(CacheMap.Value v) {
            Object val = v.getValue();
            if (val instanceof Servlet) {
                ((Servlet)val).destroy();
            }
        }
    }
}

