/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.dsp.ServletDSPContext;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ResourceCaches;
import org.zkoss.web.util.resource.ResourceLoader;
import org.zkoss.web.util.resource.ServletContextLocator;

public class InterpreterServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)InterpreterServlet.class);
    private ServletContext _ctx;
    private String _charset = "UTF-8";
    private static final String ATTR_PAGE_CACHE = "org.zkoss.web.servlet.dsp.PageCache";

    public void init(ServletConfig config) throws ServletException {
        this._ctx = config.getServletContext();
        String cs = config.getInitParameter("charset");
        if (cs != null) {
            this._charset = cs.length() > 0 ? cs : null;
        }
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = Https.getThisServletPath((ServletRequest)request);
        if (log.debugable()) {
            log.debug("Get " + path);
        }
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, this._charset);
        try {
            Interpretation cnt = (Interpretation)ResourceCaches.get(InterpreterServlet.getCache(this._ctx), this._ctx, path, null);
            if (cnt == null) {
                if (Https.isIncluded((ServletRequest)request)) {
                    log.error("Not found: " + path);
                }
                response.sendError(404);
                return;
            }
            cnt.interpret(new ServletDSPContext(this._ctx, request, response, null));
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceCache getCache(ServletContext ctx) {
        ResourceCache cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
        if (cache == null) {
            Class clazz = InterpreterServlet.class;
            synchronized (clazz) {
                cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
                if (cache == null) {
                    cache = new ResourceCache((Loader)new MyLoader(ctx), 29);
                    cache.setMaxSize(500).setLifetime(3600000);
                    ctx.setAttribute(ATTR_PAGE_CACHE, (Object)cache);
                }
            }
        }
        return cache;
    }

    private static class MyLoader
    extends ResourceLoader {
        private final Locator _locator;

        private MyLoader(ServletContext ctx) {
            this._locator = new ServletContextLocator(ctx);
        }

        protected Object parse(String path, File file, Object extra) throws Exception {
            try {
                return this.parse0(new FileInputStream(file), Interpreter.getContentType(file.getName()));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + file, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + file + "\nCause: " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getFirstStackTrace((Throwable)ex));
                }
                return null;
            }
        }

        protected Object parse(String path, URL url, Object extra) throws Exception {
            try {
                return this.parse0(url.openStream(), Interpreter.getContentType(url.getPath()));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + url, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + url + "\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                return null;
            }
        }

        private Object parse0(InputStream is, String ctype) throws Exception {
            if (is == null) {
                return null;
            }
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            return new Interpreter().parse(content, ctype, null, this._locator);
        }
    }
}

